<?php
declare(strict_types=1);

// Definisikan BASE_PATH jika belum didefinisikan
if (!defined('BASE_PATH')) {
    define('BASE_PATH', dirname(__DIR__));
}

// Autoloader sederhana
spl_autoload_register(function ($class) {
    // Hapus namespace App\ dari awal class name
    $class = str_replace('App\\', '', $class);
    $baseDir = BASE_PATH . '/app/';
    $path = $baseDir . str_replace('\\', '/', $class) . '.php';
    if (file_exists($path)) {
        require $path;
    }
});

// Router sederhana
$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$uri = rtrim($uri, '/');

// Start session for admin authentication
session_start();

if ($uri === '' || $uri === '/') {
    $controller = new App\Controllers\HomeController();
    $controller->index();
    exit;
} elseif ($uri === '/layanan' || $uri === '/services') {
    $controller = new App\Controllers\ServiceController();
    $controller->index();
    exit;
} elseif ($uri === '/kontak' || $uri === '/contact') {
    $controller = new App\Controllers\ContactController();
    $controller->index();
    exit;
} elseif ($uri === '/kontak/kirim' || $uri === '/contact/send') {
    $controller = new App\Controllers\ContactController();
    $controller->send();
    exit;
} 
// Admin routes
elseif ($uri === '/admin/login') {
    $controller = new App\Controllers\Admin\AuthController();
    $controller->login();
    exit;
} elseif ($uri === '/admin/auth') {
    $controller = new App\Controllers\Admin\AuthController();
    $controller->auth();
    exit;
} elseif ($uri === '/admin/logout') {
    $controller = new App\Controllers\Admin\AuthController();
    $controller->logout();
    exit;
} elseif ($uri === '/admin' || $uri === '/admin/dashboard') {
    $controller = new App\Controllers\Admin\DashboardController();
    $controller->index();
    exit;
} elseif ($uri === '/admin/services') {
    $controller = new App\Controllers\Admin\ServiceController();
    $controller->index();
    exit;
} elseif (preg_match('/^\/admin\/services\/edit\/([a-zA-Z0-9_-]+)$/', $uri, $matches)) {
    $controller = new App\Controllers\Admin\ServiceController();
    $controller->edit($matches[1]);
    exit;
} elseif ($uri === '/admin/services/update') {
    $controller = new App\Controllers\Admin\ServiceController();
    $controller->update();
    exit;
} 
// Routing untuk pesan customer
elseif ($uri === '/admin/messages') {
    $controller = new App\Controllers\Admin\MessageController();
    $controller->index();
    exit;
} elseif (preg_match('/^\/admin\/messages\/view\/(\d+)$/', $uri, $matches)) {
    $controller = new App\Controllers\Admin\MessageController();
    $controller->view($matches[1]);
    exit;
} elseif ($uri === '/admin/messages/reply') {
    $controller = new App\Controllers\Admin\MessageController();
    $controller->reply();
    exit;
}
// Routing untuk notifikasi
elseif ($uri === '/admin/notifications/unread') {
    $controller = new App\Controllers\Admin\NotificationController();
    $controller->getUnread();
    exit;
} elseif ($uri === '/admin/notifications/mark-read') {
    $controller = new App\Controllers\Admin\NotificationController();
    $controller->markAsRead();
    exit;
} elseif ($uri === '/admin/notifications/mark-all-read') {
    $controller = new App\Controllers\Admin\NotificationController();
    $controller->markAllAsRead();
    exit;
} elseif ($uri === '/admin/notifications/unread-count') {
    header('Content-Type: application/json');
    $controller = new App\Controllers\Admin\NotificationController();
    $count = $controller->getUnreadCount();
    echo json_encode(['count' => $count]);
    exit;
} elseif ($uri === '/admin/settings/general') {
    $controller = new App\Controllers\Admin\SettingsController();
    $controller->general();
    exit;
}
// Pengaturan Tampilan dihapus

http_response_code(404);
echo '<!DOCTYPE html><html><head><meta charset="utf-8"><title>404</title></head><body style="font-family:system-ui,sans-serif"><h1>404 Not Found</h1><p>Halaman tidak ditemukan.</p></body></html>';