-- File SQL untuk semua definisi tabel CreateWeb
-- Dibuat pada: <?php echo date('Y-m-d H:i:s'); ?>

-- Membuat database jika belum ada
CREATE DATABASE IF NOT EXISTS `createweb`;
USE `createweb`;

-- Tabel untuk menyimpan data pengunjung
CREATE TABLE IF NOT EXISTS `visitors` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `visit_date` DATE NOT NULL,
    `count` INT NOT NULL DEFAULT 1,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Tabel untuk menyimpan data aktivitas bulanan
CREATE TABLE IF NOT EXISTS `monthly_activities` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `month` INT NOT NULL,
    `year` INT NOT NULL,
    `activity_count` INT NOT NULL DEFAULT 0,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY `month_year_unique` (`month`, `year`)
);

-- Tabel untuk menyimpan data pesanan
CREATE TABLE IF NOT EXISTS `orders` (
    `id` INT(11) NOT NULL AUTO_INCREMENT,
    `customer_name` VARCHAR(100) NOT NULL,
    `service_name` VARCHAR(100) NOT NULL,
    `order_date` DATE NOT NULL,
    `status` ENUM('pending','process','completed') NOT NULL DEFAULT 'pending',
    `amount` DECIMAL(10,2) NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabel untuk menyimpan data admin
CREATE TABLE IF NOT EXISTS `user_admin` (
    `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `username` VARCHAR(50) NOT NULL,
    `email` VARCHAR(100) NOT NULL,
    `password` VARCHAR(255) NOT NULL,
    `created_at` DATETIME NULL,
    `updated_at` DATETIME NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `username` (`username`),
    UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Tabel untuk menyimpan data harga layanan
CREATE TABLE IF NOT EXISTS `service_prices` (
    `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `service_code` VARCHAR(50) NOT NULL,
    `service_name` VARCHAR(100) NOT NULL,
    `price` DECIMAL(10,2) NOT NULL,
    `created_at` DATETIME NULL,
    `updated_at` DATETIME NULL,
    PRIMARY KEY (`id`),
    UNIQUE KEY `service_code` (`service_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Tabel untuk menyimpan pesan dari customer
CREATE TABLE IF NOT EXISTS `messages` (
    `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `name` VARCHAR(100) NOT NULL,
    `email` VARCHAR(100) NOT NULL,
    `subject` VARCHAR(200) NOT NULL,
    `message` TEXT NOT NULL,
    `is_read` TINYINT(1) NOT NULL DEFAULT 0,
    `is_replied` TINYINT(1) NOT NULL DEFAULT 0,
    `reply` TEXT NULL,
    `reply_date` DATETIME NULL,
    `created_at` DATETIME NOT NULL,
    `updated_at` DATETIME NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Tabel untuk menyimpan notifikasi
CREATE TABLE IF NOT EXISTS `notifications` (
    `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `type` VARCHAR(50) NOT NULL,
    `message` VARCHAR(255) NOT NULL,
    `is_read` TINYINT(1) NOT NULL DEFAULT 0,
    `related_id` INT(11) NULL,
    `created_at` DATETIME NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Menambahkan data default untuk user admin
INSERT INTO `user_admin` (`username`, `email`, `password`, `created_at`, `updated_at`) VALUES
('admin', 'admin@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', NOW(), NOW());
-- Password default: password