<section class="py-16">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <h1 class="text-4xl font-bold mb-8">Layanan <span class="text-brand-yellow">Kami</span></h1>
    
    <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8 mb-16">
      <div class="p-6 rounded-xl bg-white/5 border border-white/10 hover:border-brand-yellow transition">
        <div class="w-12 h-12 bg-brand-yellow/20 rounded-lg flex items-center justify-center mb-4">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4" />
          </svg>
        </div>
        <h3 class="text-xl font-semibold mb-2">Company Profile</h3>
        <p class="text-white/70 mb-4">Website profil perusahaan untuk memperkuat kepercayaan dan reputasi bisnis Anda.</p>
        <ul class="space-y-2 text-white/70">
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Desain profesional
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Halaman tentang perusahaan
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Portofolio proyek
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Formulir kontak
          </li>
        </ul>
        <div class="mt-6 pt-4 border-t border-white/10">
          <div class="flex justify-between items-center">
            <span class="text-white/70">Mulai dari</span>
            <span class="text-2xl font-bold text-brand-yellow" data-price="company-profile">Rp 3.500.000</span>
          </div>
          <a href="/contact" class="mt-4 block text-center bg-brand-yellow hover:bg-yellow-500 text-black font-medium py-2 px-4 rounded-lg transition-all duration-300">
            Pesan Sekarang
          </a>
        </div>
      </div>
      
      <div class="p-6 rounded-xl bg-white/5 border border-white/10 hover:border-brand-yellow transition">
        <div class="w-12 h-12 bg-brand-yellow/20 rounded-lg flex items-center justify-center mb-4">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z" />
          </svg>
        </div>
        <h3 class="text-xl font-semibold mb-2">E-Commerce</h3>
        <p class="text-white/70 mb-4">Toko online lengkap dengan katalog produk dan sistem checkout yang aman.</p>
        <ul class="space-y-2 text-white/70">
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Katalog produk
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Keranjang belanja
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Pembayaran online
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Manajemen pesanan
          </li>
        </ul>
        <div class="mt-6 pt-4 border-t border-white/10">
          <div class="flex justify-between items-center">
            <span class="text-white/70">Mulai dari</span>
            <span class="text-2xl font-bold text-brand-yellow" data-price="ecommerce">Rp 7.500.000</span>
          </div>
          <a href="/contact" class="mt-4 block text-center bg-brand-yellow hover:bg-yellow-500 text-black font-medium py-2 px-4 rounded-lg transition-all duration-300">
            Pesan Sekarang
          </a>
        </div>
      </div>
      
      <div class="p-6 rounded-xl bg-white/5 border border-white/10 hover:border-brand-yellow transition">
        <div class="w-12 h-12 bg-brand-yellow/20 rounded-lg flex items-center justify-center mb-4">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
          </svg>
        </div>
        <h3 class="text-xl font-semibold mb-2">Landing Page</h3>
        <p class="text-white/70 mb-4">Halaman penawaran khusus untuk kampanye pemasaran yang efektif.</p>
        <ul class="space-y-2 text-white/70">
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Desain konversi tinggi
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Call-to-action efektif
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Formulir lead capture
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Analitik performa
          </li>
        </ul>
        <div class="mt-6 pt-4 border-t border-white/10">
          <div class="flex justify-between items-center">
            <span class="text-white/70">Mulai dari</span>
            <span class="text-2xl font-bold text-brand-yellow" data-price="landing-page">Rp 2.500.000</span>
          </div>
          <a href="/contact" class="mt-4 block text-center bg-brand-yellow hover:bg-yellow-500 text-black font-medium py-2 px-4 rounded-lg transition-all duration-300">
            Pesan Sekarang
          </a>
        </div>
      </div>
      
      <div class="p-6 rounded-xl bg-white/5 border border-white/10 hover:border-brand-yellow transition">
        <div class="w-12 h-12 bg-brand-yellow/20 rounded-lg flex items-center justify-center mb-4">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 20l4-16m4 4l4 4-4 4M6 16l-4-4 4-4" />
          </svg>
        </div>
        <h3 class="text-xl font-semibold mb-2">Custom Development</h3>
        <p class="text-white/70 mb-4">Solusi kustom sesuai kebutuhan unik bisnis Anda.</p>
        <ul class="space-y-2 text-white/70">
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Aplikasi web kustom
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Sistem manajemen konten
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Integrasi API
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Solusi bisnis spesifik
          </li>
        </ul>
        <div class="mt-6 pt-4 border-t border-white/10">
          <div class="flex justify-between items-center">
            <span class="text-white/70">Mulai dari</span>
            <span class="text-2xl font-bold text-brand-yellow" data-price="custom-dev">Rp 10.000.000</span>
          </div>
          <a href="/contact" class="mt-4 block text-center bg-brand-yellow hover:bg-yellow-500 text-black font-medium py-2 px-4 rounded-lg transition-all duration-300">
            Pesan Sekarang
          </a>
        </div>
      </div>
      
      <div class="p-6 rounded-xl bg-white/5 border border-white/10 hover:border-brand-yellow transition">
        <div class="w-12 h-12 bg-brand-yellow/20 rounded-lg flex items-center justify-center mb-4">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z" />
          </svg>
        </div>
        <h3 class="text-xl font-semibold mb-2">Optimasi & Maintenance</h3>
        <p class="text-white/70 mb-4">Perawatan, peningkatan performa, dan keamanan berkala.</p>
        <ul class="space-y-2 text-white/70">
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Optimasi kecepatan
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Update keamanan
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Backup reguler
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Monitoring 24/7
          </li>
        </ul>
        <div class="mt-6 pt-4 border-t border-white/10">
          <div class="flex justify-between items-center">
            <span class="text-white/70">Mulai dari</span>
            <span class="text-2xl font-bold text-brand-yellow" data-price="maintenance">Rp 1.500.000</span>
          </div>
          <a href="/contact" class="mt-4 block text-center bg-brand-yellow hover:bg-yellow-500 text-black font-medium py-2 px-4 rounded-lg transition-all duration-300">
            Pesan Sekarang
          </a>
        </div>
      </div>
      
      <div class="p-6 rounded-xl bg-white/5 border border-white/10 hover:border-brand-yellow transition">
        <div class="w-12 h-12 bg-brand-yellow/20 rounded-lg flex items-center justify-center mb-4">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4" />
          </svg>
        </div>
        <h3 class="text-xl font-semibold mb-2">Integrasi Sistem</h3>
        <p class="text-white/70 mb-4">Integrasi API, CRM, pembayaran, dan lainnya.</p>
        <ul class="space-y-2 text-white/70">
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Integrasi payment gateway
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Integrasi CRM
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Integrasi media sosial
          </li>
          <li class="flex items-center">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow mr-2" viewBox="0 0 20 20" fill="currentColor">
              <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd" />
            </svg>
            Integrasi API pihak ketiga
          </li>
        </ul>
        <div class="mt-6 pt-4 border-t border-white/10">
          <div class="flex justify-between items-center">
            <span class="text-white/70">Mulai dari</span>
            <span class="text-2xl font-bold text-brand-yellow" data-price="integration">Rp 5.000.000</span>
          </div>
          <a href="/contact" class="mt-4 block text-center bg-brand-yellow hover:bg-yellow-500 text-black font-medium py-2 px-4 rounded-lg transition-all duration-300">
            Pesan Sekarang
          </a>
        </div>
      </div>
    </div>
    
    <!-- Cara Kerja CreateWeb -->
    <div class="mb-16">
      <h2 class="text-3xl font-bold mb-8">Cara Kerja <span class="text-brand-yellow">CreateWeb</span></h2>
      <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-8">
        <div class="bg-white/5 border border-white/10 rounded-xl p-6 relative hover:border-brand-yellow transition-all duration-300 transform hover:-translate-y-2">
          <div class="absolute -top-5 left-1/2 transform -translate-x-1/2 w-10 h-10 rounded-full bg-brand-yellow flex items-center justify-center text-black font-bold text-xl">1</div>
          <h3 class="text-xl font-semibold mt-4 mb-3 text-center">Konsultasi</h3>
          <p class="text-white/70 text-center">Diskusi kebutuhan dan tujuan website Anda bersama tim ahli kami.</p>
        </div>
        
        <div class="bg-white/5 border border-white/10 rounded-xl p-6 relative hover:border-brand-yellow transition-all duration-300 transform hover:-translate-y-2">
          <div class="absolute -top-5 left-1/2 transform -translate-x-1/2 w-10 h-10 rounded-full bg-brand-yellow flex items-center justify-center text-black font-bold text-xl">2</div>
          <h3 class="text-xl font-semibold mt-4 mb-3 text-center">Perencanaan</h3>
          <p class="text-white/70 text-center">Pembuatan wireframe, desain, dan perencanaan fitur sesuai kebutuhan.</p>
        </div>
        
        <div class="bg-white/5 border border-white/10 rounded-xl p-6 relative hover:border-brand-yellow transition-all duration-300 transform hover:-translate-y-2">
          <div class="absolute -top-5 left-1/2 transform -translate-x-1/2 w-10 h-10 rounded-full bg-brand-yellow flex items-center justify-center text-black font-bold text-xl">3</div>
          <h3 class="text-xl font-semibold mt-4 mb-3 text-center">Pengembangan</h3>
          <p class="text-white/70 text-center">Pembuatan website dengan teknologi terkini dan standar industri.</p>
        </div>
        
        <div class="bg-white/5 border border-white/10 rounded-xl p-6 relative hover:border-brand-yellow transition-all duration-300 transform hover:-translate-y-2">
          <div class="absolute -top-5 left-1/2 transform -translate-x-1/2 w-10 h-10 rounded-full bg-brand-yellow flex items-center justify-center text-black font-bold text-xl">4</div>
          <h3 class="text-xl font-semibold mt-4 mb-3 text-center">Peluncuran</h3>
          <p class="text-white/70 text-center">Pengujian menyeluruh dan peluncuran website ke server produksi.</p>
        </div>
      </div>
    </div>

    <div class="bg-white/5 border border-white/10 rounded-xl p-8 text-center">
      <h2 class="text-2xl font-semibold mb-4">Butuh Layanan Kustom?</h2>
      <p class="text-white/70 mb-6 max-w-2xl mx-auto">Kami siap membantu kebutuhan spesifik bisnis Anda. Hubungi tim kami untuk konsultasi gratis dan penawaran khusus.</p>
      <a href="/kontak" class="inline-block px-6 py-3 bg-brand-yellow text-black font-medium rounded-lg hover:bg-opacity-90 transition">Hubungi Kami</a>
    </div>
  </div>
</section>