<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= isset($title) ? htmlspecialchars($title) : 'CreateWeb'; ?></title>
  <meta name="description" content="<?= isset($meta_description) ? htmlspecialchars($meta_description) : 'CreateWeb - Jasa pembuatan website'; ?>">
  <script src="https://cdn.tailwindcss.com?mode=development"></script>
  <!-- Font Awesome CDN for icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" integrity="sha512-1r6l3vHnQm+WQwGvRZCwJf8T0tVZsYv+7YwC6uC4YjZzqXUeQ7p8hJrS6Zk5kZ8XjIY9wF7lA+2fP8oA9FQK0g==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <script>
    tailwind.config = {
      theme: {
        extend: {
          colors: {
            brand: {
              black: '#0a0a0a',
              white: '#ffffff',
              yellow: '#facc15',
            }
          }
        }
      }
    }
  </script>
  <style>
    html { scroll-behavior: smooth; }
    
    /* Animasi untuk menu mobile */
    #mobile-menu {
      transition: all 0.3s ease-in-out;
      max-height: 0;
      overflow: hidden;
      opacity: 0;
      transform: translateY(-10px);
    }
    #mobile-menu.open {
      max-height: 300px;
      opacity: 1;
      transform: translateY(0);
    }
    
    /* Efek hover pada tombol hamburger */
    #mobile-menu-button {
      transition: transform 0.2s ease;
    }
    #mobile-menu-button:hover {
      transform: scale(1.1);
    }
    
    /* Efek hover pada menu items */
    #mobile-menu a {
      transition: all 0.2s ease;
    }
    #mobile-menu a:hover {
      padding-left: 1rem;
    }
  </style>
</head>
<body class="bg-brand-black text-brand-white">
  <?php
  // Ambil settings general dari session jika tersedia
  $settings = $_SESSION['settings_general'] ?? [
    'email' => 'hallo@createweb.id',
    'whatsapp_number' => '+62 812-3456-7890',
    'address' => 'Jl. Contoh No. 123, Jakarta'
  ];
  $waDigits = preg_replace('/\D+/', '', $settings['whatsapp_number'] ?? '');
  ?>
  <header class="sticky top-0 z-30 backdrop-blur bg-brand-black/70 border-b border-white/10">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 flex items-center justify-between h-16">
      <a href="/" class="flex items-center gap-3">
        <img src="/assets/logo.svg" alt="CreateWeb" class="h-8 w-auto">
        <span class="sr-only">CreateWeb</span>
      </a>
      
      <!-- Desktop Navigation -->
      <nav class="hidden md:flex items-center gap-6">
        <a href="/" class="<?= $_SERVER['REQUEST_URI'] == '/' ? 'text-brand-yellow font-medium' : 'text-white/80 hover:text-brand-yellow' ?> transition">Beranda</a>
        <a href="/layanan" class="<?= $_SERVER['REQUEST_URI'] == '/layanan' ? 'text-brand-yellow font-medium' : 'text-white/80 hover:text-brand-yellow' ?> transition">Layanan</a>
        <a href="/kontak" class="<?= $_SERVER['REQUEST_URI'] == '/kontak' ? 'text-brand-yellow font-medium' : 'text-white/80 hover:text-brand-yellow' ?> transition">Kontak</a>
      </nav>
      
      <!-- Desktop CTA Button -->
      <a href="/kontak" class="hidden md:inline-flex items-center px-4 py-2 rounded-md bg-brand-yellow text-black font-semibold hover:bg-yellow-400 transition">
        Konsultasi Gratis
      </a>
      
      <!-- Mobile Menu Button -->
      <button id="mobile-menu-button" class="md:hidden flex items-center justify-center p-2 rounded-md text-white hover:text-brand-yellow focus:outline-none">
        <svg class="h-6 w-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
        </svg>
      </button>
    </div>
    
    <!-- Mobile Navigation Menu -->
    <div id="mobile-menu" class="md:hidden hidden bg-brand-black/95 border-b border-white/10">
      <div class="px-4 py-3 space-y-3">
        <a href="/" class="block <?= $_SERVER['REQUEST_URI'] == '/' ? 'text-brand-yellow bg-white/5 font-medium' : 'text-white/80 hover:text-brand-yellow hover:bg-white/5' ?> transition py-2 px-3 rounded-md">Beranda</a>
        <a href="/layanan" class="block <?= $_SERVER['REQUEST_URI'] == '/layanan' ? 'text-brand-yellow bg-white/5 font-medium' : 'text-white/80 hover:text-brand-yellow hover:bg-white/5' ?> transition py-2 px-3 rounded-md">Layanan</a>
        <a href="/kontak" class="block <?= $_SERVER['REQUEST_URI'] == '/kontak' ? 'text-brand-yellow bg-white/5 font-medium' : 'text-white/80 hover:text-brand-yellow hover:bg-white/5' ?> transition py-2 px-3 rounded-md">Kontak</a>
        <a href="/kontak" class="block text-center mt-4 px-4 py-2 rounded-md bg-brand-yellow text-black font-semibold hover:bg-yellow-400 transition">
          Konsultasi Gratis
        </a>
      </div>
    </div>
  </header>

  <main>
    <?php $content(); ?>
  </main>

  <!-- WhatsApp Floating Button -->
  <a href="https://wa.me/<?= htmlspecialchars($waDigits ?: '6281234567890') ?>" class="fixed bottom-6 right-6 bg-green-500 text-white rounded-lg px-4 py-3 shadow-xl hover:bg-green-600 transition-all duration-300 z-50 flex items-center justify-center hover:scale-105 animate-bounce-slow" title="Chat WhatsApp">
    <svg class="h-6 w-6 mr-2" fill="currentColor" viewBox="0 0 24 24">
      <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
    </svg>
    <span class="font-medium">Chat WhatsApp</span>
  </a>
  
  <style>
    @keyframes bounce-slow { 0%, 100% { transform: translateY(0); } 50% { transform: translateY(-10px); } }
    .animate-bounce-slow { animation: bounce-slow 3s infinite; }
  </style>

  <footer class="border-t border-white/10 mt-16">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8 grid md:grid-cols-3 gap-8">
      <div>
        <div class="flex items-center gap-3">
          <img src="/assets/logo.svg" alt="CreateWeb" class="h-6 w-auto">
          <span class="text-white/80">CreateWeb</span>
        </div>
        <p class="text-white/60 mt-3">Jasa pembuatan website profesional untuk UMKM, startup, dan korporasi.</p>
      </div>
      <div>
        <h3 class="font-semibold mb-3">Navigasi</h3>
        <ul class="space-y-2 text-white/80">
          <li><a href="#layanan" class="hover:text-brand-yellow transition">Layanan</a></li>
          <li><a href="#mengapa" class="hover:text-brand-yellow transition">Mengapa Kami</a></li>
          <li><a href="#kontak" class="hover:text-brand-yellow transition">Kontak</a></li>
        </ul>
      </div>
      <div>
        <h3 class="font-semibold mb-3">Kontak</h3>
        <ul class="space-y-2 text-white/80">
          <li>Email: <a href="mailto:<?= htmlspecialchars($settings['email'] ?? 'hallo@createweb.id') ?>" class="hover:text-brand-yellow"><?= htmlspecialchars($settings['email'] ?? 'hallo@createweb.id') ?></a></li>
          <li>Alamat: <span class="hover:text-brand-yellow"><?= htmlspecialchars($settings['address'] ?? 'Jl. Contoh No. 123, Jakarta') ?></span></li>
          <li>WhatsApp: <a href="https://wa.me/<?= htmlspecialchars($waDigits ?: '6281234567890') ?>" class="hover:text-brand-yellow" target="_blank" rel="noopener"><?= htmlspecialchars($settings['whatsapp_number'] ?? '+62 812-3456-7890') ?></a></li>
        </ul>
      </div>
    </div>
    <div class="text-center text-white/60 py-6 border-t border-white/10">
      &copy; <?= date('Y'); ?> CreateWeb. All rights reserved.
    </div>
  </footer>

  <!-- JavaScript untuk menu mobile dan tracking pengunjung -->
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      const mobileMenuButton = document.getElementById('mobile-menu-button');
      const mobileMenu = document.getElementById('mobile-menu');
      
      // Tracking pengunjung website - dipanggil saat halaman dimuat
      fetch('/tracker.php', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify({
          page: window.location.pathname
        })
      })
        .then(response => response.json())
        .then(data => console.log('Visitor tracked:', data))
        .catch(error => console.error('Error tracking visitor:', error));
      
      // Fungsi untuk menutup menu
      function closeMenu() {
        mobileMenu.classList.add('hidden');
        mobileMenu.classList.remove('open');
      }
      
      // Fungsi untuk membuka/menutup menu
      function toggleMenu(event) {
        event.stopPropagation(); // Mencegah event bubbling
        mobileMenu.classList.toggle('hidden');
        mobileMenu.classList.toggle('open');
      }
      
      // Toggle menu saat tombol hamburger diklik
      mobileMenuButton.addEventListener('click', toggleMenu);
      
      // Mencegah menu tertutup saat mengklik di dalam menu
      mobileMenu.addEventListener('click', function(event) {
        event.stopPropagation();
      });
      
      // Menutup menu saat link di klik
      const mobileLinks = mobileMenu.querySelectorAll('a');
      mobileLinks.forEach(link => {
        link.addEventListener('click', closeMenu);
      });
      
      // Menutup menu saat mengklik di luar menu
      document.addEventListener('click', function(event) {
        // Jika menu terbuka dan klik terjadi di luar menu dan bukan pada tombol menu
        if (!mobileMenu.classList.contains('hidden') && 
            event.target !== mobileMenuButton && 
            !mobileMenuButton.contains(event.target)) {
          closeMenu();
        }
      });
    });
  </script>
</body>
</html>