<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Admin Panel' ?> - CreateWeb</title>
    <script src="https://cdn.tailwindcss.com?mode=development"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="/assets/js/notifications.js"></script>
    <style>
        :root {
            --sidebar-bg: #000000;
            --sidebar-text: #ffffff;
            --sidebar-hover: #222222;
            --sidebar-active: #ffcc00;
            --sidebar-border: rgba(255, 255, 255, 0.1);
            --transition-speed: 0.25s;
        }
        
        /* Notification Styles */
        .notification-dropdown {
            position: absolute;
            right: 0;
            top: 100%;
            width: 320px;
            background-color: white;
            border-radius: 0.75rem;
            box-shadow: 0 5px 25px rgba(0,0,0,0.15);
            z-index: 1000;
            display: none;
            max-height: 400px;
            overflow-y: auto;
            border: 1px solid rgba(0,0,0,0.05);
        }
        
        .notification-dropdown.show {
            display: block;
            animation: fadeInDown 0.3s ease forwards;
        }
        
        @keyframes fadeInDown {
            from {
                opacity: 0;
                transform: translateY(-10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .notification-item {
            padding: 0.75rem 1rem;
            border-bottom: 1px solid #f0f0f0;
            display: flex;
            align-items: center;
            color: #333;
            text-decoration: none;
            transition: all 0.2s ease;
        }
        
        .notification-item:hover {
            background-color: #f5f7fa;
        }
        
        .notification-item:last-child {
            border-bottom: none;
        }
        
        .notification-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 0.75rem;
            background-color: #e6f7ff;
            color: #1890ff;
        }
        
        .notification-content {
            flex: 1;
        }
        
        .notification-content p {
            margin: 0;
            line-height: 1.4;
        }
        
        .notification-time {
            font-size: 0.75rem;
            color: #999;
            margin-top: 0.25rem;
        }
        
        .mark-all-read {
            cursor: pointer;
            color: #1890ff;
            font-weight: 500;
            transition: all 0.2s ease;
        }
        
        .mark-all-read:hover {
            text-decoration: underline;
            color: #096dd9;
        }
        
        .notification-badge {
            position: absolute;
            top: -5px;
            right: -5px;
            background-color: #f5222d;
            color: white;
            border-radius: 50%;
            min-width: 18px;
            height: 18px;
            font-size: 0.7rem;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 0 4px;
            box-shadow: 0 2px 5px rgba(245, 34, 45, 0.5);
            font-weight: bold;
            border: 1.5px solid white;
        }
        
        /* Toast Notification */
        .notification-toast {
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 300px;
            background-color: white;
            border-radius: 0.5rem;
            box-shadow: 0 0 15px rgba(0,0,0,0.2);
            z-index: 1050;
            transform: translateY(100%);
            opacity: 0;
            transition: all 0.3s ease;
        }
        
        .notification-toast.show {
            transform: translateY(0);
            opacity: 1;
        }
        
        .notification-toast-header {
            padding: 0.75rem 1rem;
            border-bottom: 1px solid #f0f0f0;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .notification-toast-body {
            padding: 0.75rem 1rem;
        }
        
        .btn-close {
            background: transparent;
            border: none;
            font-size: 1.25rem;
            cursor: pointer;
            color: #999;
        }
        
        /* Base Sidebar Styles */
        .sidebar {
            background-color: var(--sidebar-bg);
            color: var(--sidebar-text);
            height: 100vh;
            transition: all var(--transition-speed);
            width: 16rem;
        }
        
        /* Logo Container */
        .logo-container {
            padding: 1.5rem;
            border-bottom: 1px solid var(--sidebar-border);
            margin-bottom: 1rem;
        }
        
        /* Sidebar Sections */
        .sidebar-section {
            margin-bottom: 0.25rem;
            position: relative;
        }
        
        /* Sidebar Links */
        .sidebar-link {
            display: flex;
            align-items: center;
            padding: 0.875rem 1.5rem;
            color: var(--sidebar-text);
            text-decoration: none;
            transition: all var(--transition-speed);
            position: relative;
            font-weight: 500;
            gap: 0.75rem;
        }
        
        .sidebar-link i {
            width: 1.25rem;
            text-align: center;
            font-size: 1rem;
            opacity: 0.85;
        }
        
        .sidebar-link span {
            flex: 1;
        }
        
        .sidebar-link:hover {
            background-color: var(--sidebar-hover);
        }
        
        .sidebar-link.active {
            background-color: var(--sidebar-active);
            color: #000000;
            font-weight: 600;
            border-left: 4px solid white;
            padding-left: calc(1.5rem - 4px);
        }
        
        /* Dropdown Toggle */
        .sidebar-dropdown-toggle {
            justify-content: space-between;
        }
        
        .dropdown-icon {
            transition: transform var(--transition-speed);
            font-size: 0.75rem;
            opacity: 0.7;
        }
        
        .sidebar-dropdown-toggle.open .dropdown-icon {
            transform: rotate(180deg);
        }
        
        /* Submenu Styles */
        .sidebar-submenu {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease-out;
            background-color: rgba(0, 0, 0, 0.2);
            margin-left: 1rem;
            margin-right: 0.5rem;
            border-radius: 0.5rem;
        }
        
        .sidebar-submenu.open {
            max-height: 500px;
            margin-top: 0.25rem;
            margin-bottom: 0.5rem;
            border-left: 2px solid var(--sidebar-active);
        }
        
        .sidebar-submenu-link {
            display: flex;
            align-items: center;
            padding: 0.75rem 1rem;
            color: var(--sidebar-text);
            text-decoration: none;
            transition: all var(--transition-speed);
            font-size: 0.9rem;
            gap: 0.5rem;
            border-radius: 0.25rem;
            margin: 0.25rem 0.5rem;
        }
        
        .sidebar-submenu-link i {
            width: 1rem;
            text-align: center;
            opacity: 0.7;
        }
        
        .sidebar-submenu-link:hover {
            background-color: var(--sidebar-hover);
        }
        
        .sidebar-submenu-link.active {
            background-color: var(--sidebar-active);
            color: #000000;
            font-weight: 600;
            border-left: 3px solid white;
            padding-left: calc(1rem - 3px);
        }
        
        /* Logout Button */
        .sidebar-link.logout {
            margin: 1rem;
            border-radius: 0.5rem;
            border: 1px solid var(--sidebar-active);
            background-color: rgba(255, 204, 0, 0.1);
            justify-content: center;
            font-weight: 600;
        }
        
        .sidebar-link.logout:hover {
            background-color: var(--sidebar-active);
            color: #000000;
        }
        
        /* Navigation Scrollbar */
        nav {
            padding: 0.5rem;
            scrollbar-width: thin;
            scrollbar-color: var(--sidebar-active) var(--sidebar-bg);
        }
        
        nav::-webkit-scrollbar {
            width: 6px;
        }
        
        nav::-webkit-scrollbar-track {
            background: var(--sidebar-bg);
        }
        
        nav::-webkit-scrollbar-thumb {
            background-color: var(--sidebar-active);
            border-radius: 20px;
        }
    </style>
</head>
<body class="bg-gray-100">
    <div class="flex h-screen">
        
        <!-- Sidebar -->
        <div class="w-64 sidebar shadow-xl flex flex-col">
            <div class="logo-container flex justify-center items-center py-5 border-b border-white/10">
                <img src="/assets/logo.svg" alt="CreateWeb Logo" class="h-12">
            </div>
            <nav class="flex-grow overflow-y-auto">
                <div class="sidebar-section">
                    <a href="/admin/dashboard" class="sidebar-link <?= strpos($_SERVER['REQUEST_URI'], '/admin/dashboard') !== false ? 'active' : '' ?>">
                        <i class="fas fa-tachometer-alt"></i> Dashboard
                    </a>
                </div>
                
                <!-- Menu Pesan Customer -->
                <div class="sidebar-section">
                    <a href="/admin/messages" class="sidebar-link <?= strpos($_SERVER['REQUEST_URI'], '/admin/messages') !== false ? 'active' : '' ?>">
                        <i class="fas fa-envelope"></i> Pesan Customer
                    </a>
                </div>
                
                <!-- Menu Pengaturan dengan submenu -->
                <div class="sidebar-section">
                    <a href="#" class="sidebar-link sidebar-dropdown-toggle <?= (strpos($_SERVER['REQUEST_URI'], '/admin/settings/') !== false) ? 'open' : '' ?>" data-target="pengaturan-submenu">
                        <i class="fas fa-cog"></i> 
                        <span>Pengaturan</span>
                        <i class="fas fa-chevron-down dropdown-icon"></i>
                    </a>
                    <div id="pengaturan-submenu" class="sidebar-submenu <?= (strpos($_SERVER['REQUEST_URI'], '/admin/settings/') !== false) ? 'open' : '' ?>">
                        <a href="/admin/settings/general" class="sidebar-submenu-link <?= strpos($_SERVER['REQUEST_URI'], '/admin/settings/general') !== false ? 'active' : '' ?>">
                            <i class="fas fa-sliders-h"></i> Umum
                        </a>

                    </div>
                </div>
                
                <!-- Menu Account -->
                <div class="sidebar-section">
                    <a href="#" class="sidebar-link sidebar-dropdown-toggle <?= (strpos($_SERVER['REQUEST_URI'], '/admin/account/') !== false) ? 'open' : '' ?>" data-target="account-submenu">
                        <i class="fas fa-user-circle"></i>
                        <span>Account</span>
                        <i class="fas fa-chevron-down dropdown-icon"></i>
                    </a>
                    <div id="account-submenu" class="sidebar-submenu <?= (strpos($_SERVER['REQUEST_URI'], '/admin/account/') !== false) ? 'open' : '' ?>">
                        <a href="/admin/account/profile" class="sidebar-submenu-link <?= strpos($_SERVER['REQUEST_URI'], '/admin/account/profile') !== false ? 'active' : '' ?>">
                            <i class="fas fa-id-card"></i> Profil
                        </a>
                        <a href="/admin/account/security" class="sidebar-submenu-link <?= strpos($_SERVER['REQUEST_URI'], '/admin/account/security') !== false ? 'active' : '' ?>">
                            <i class="fas fa-shield-alt"></i> Keamanan
                        </a>
                    </div>
                </div>
                
                <!-- Menu Create Layanan -->
                <div class="sidebar-section">
                    <a href="#" class="sidebar-link sidebar-dropdown-toggle <?= (strpos($_SERVER['REQUEST_URI'], '/admin/services') !== false) ? 'open' : '' ?>" data-target="layanan-submenu">
                        <i class="fas fa-cogs"></i>
                        <span>Create Layanan</span>
                        <i class="fas fa-chevron-down dropdown-icon"></i>
                    </a>
                    <div id="layanan-submenu" class="sidebar-submenu <?= (strpos($_SERVER['REQUEST_URI'], '/admin/services') !== false) ? 'open' : '' ?>">
                        <a href="/admin/services" class="sidebar-submenu-link <?= strpos($_SERVER['REQUEST_URI'], '/admin/services') !== false && !strpos($_SERVER['REQUEST_URI'], '/admin/services/new') ? 'active' : '' ?>">
                            <i class="fas fa-list"></i> Daftar Layanan
                        </a>
                        <a href="/admin/services/new" class="sidebar-submenu-link <?= strpos($_SERVER['REQUEST_URI'], '/admin/services/new') !== false ? 'active' : '' ?>">
                            <i class="fas fa-plus"></i> Tambah Layanan
                        </a>
                    </div>
                </div>
                
                <!-- Menu Jam Kerja -->
                <div class="sidebar-section">
                    <a href="/admin/working-hours" class="sidebar-link <?= strpos($_SERVER['REQUEST_URI'], '/admin/working-hours') !== false ? 'active' : '' ?>">
                        <i class="fas fa-clock"></i> Jam Kerja
                    </a>
                </div>
            </nav>
            <div class="mt-auto">
                <a href="/admin/logout" class="sidebar-link logout">
                    <i class="fas fa-sign-out-alt"></i> Logout
                </a>
            </div>
        </div>
        
        <script>
            // JavaScript untuk fungsionalitas dropdown pada sidebar
            document.addEventListener('DOMContentLoaded', function() {
                const dropdownToggles = document.querySelectorAll('.sidebar-dropdown-toggle');
                
                dropdownToggles.forEach(toggle => {
                    toggle.addEventListener('click', function(e) {
                        e.preventDefault();
                        
                        const targetId = this.getAttribute('data-target');
                        const submenu = document.getElementById(targetId);
                        
                        // Toggle class open pada submenu
                        submenu.classList.toggle('open');
                        
                        // Toggle class open pada toggle button
                        this.classList.toggle('open');
                    });
                });
                
                // Buka submenu jika ada link aktif di dalamnya
                const activeSubmenuLinks = document.querySelectorAll('.sidebar-submenu-link.active');
                activeSubmenuLinks.forEach(link => {
                    const submenu = link.closest('.sidebar-submenu');
                    if (submenu) {
                        submenu.classList.add('open');
                        const toggle = document.querySelector(`[data-target="${submenu.id}"]`);
                        if (toggle) {
                            toggle.classList.add('open');
                        }
                    }
                });
            });
        </script>
        
        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <!-- Top Header -->
            <header class="bg-white shadow-sm">
                <div class="px-6 py-4 flex justify-between items-center">
                    <div class="flex items-center">
                        <div>
                            <h2 class="text-xl font-semibold text-gray-800"><?= $title ?? 'Dashboard' ?></h2>
                            <span class="text-sm text-gray-500">Panel Admin CreateWeb</span>
                        </div>
                    </div>
                    <div class="flex items-center">
                        <div class="relative mr-4">
                            <a href="#" class="notification-bell flex items-center justify-center w-10 h-10 rounded-full hover:bg-gray-100 transition-all duration-200" id="notification-toggle">
                                <i class="fas fa-bell text-gray-700"></i>
                                <span class="notification-badge" id="notificationBadge" style="display: none;">0</span>
                            </a>
                            <div class="notification-dropdown" id="notification-dropdown">
                                <div class="flex justify-between items-center p-3 border-bottom">
                                    <h6 class="font-semibold text-gray-800 m-0">Notifikasi</h6>
                                    <a href="#" class="text-sm text-blue-500 hover:underline" id="mark-all-read">Tandai semua dibaca</a>
                                </div>
                                <div id="notification-list" class="max-h-80 overflow-y-auto"></div>
                            </div>
                        </div>
                        <div class="flex items-center bg-gray-50 rounded-full px-4 py-2 hover:bg-gray-100 transition-all duration-200 shadow-sm">
                            <div class="h-9 w-9 rounded-full bg-blue-50 flex items-center justify-center mr-2 border border-blue-100">
                                <i class="fas fa-user text-blue-500"></i>
                            </div>
                            <div>
                                <span class="font-medium text-gray-800">Admin</span>
                                <span class="block text-xs text-gray-500">Administrator</span>
                            </div>
                        </div>
                    </div>
                </div>
            </header>
            
            <!-- Content -->
            <main class="flex-1 overflow-x-hidden overflow-y-auto p-4">
                <?php if (isset($content) && is_callable($content)) $content(); ?>
            </main>
        </div>
    </div>
</body>
</html>