<section id="hero" class="relative overflow-hidden">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-20">
    <div class="grid md:grid-cols-2 gap-10 items-center">
      <div>
        <h1 class="text-4xl sm:text-5xl font-extrabold leading-tight">
          Wujudkan Website Impian Bisnis Anda dengan
          <span class="text-brand-yellow">CreateWeb</span>
        </h1>
        <p class="mt-4 text-white/80">
          Dapatkan website profesional dengan desain modern, SEO-friendly, dan fitur lengkap untuk mengembangkan bisnis online Anda.
        </p>
        <div class="mt-6 flex flex-wrap gap-3">
          <a href="#layanan" class="px-5 py-3 rounded-md bg-brand-yellow text-black font-semibold hover:bg-yellow-400 transition">Lihat Layanan</a>
          <a href="/kontak#form-konsultasi" class="relative overflow-hidden px-5 py-3 rounded-md border border-white/25 text-white/90 bg-white/5 backdrop-blur-sm transition-all duration-300 inline-flex items-center gap-2 hover:text-white hover:bg-white/15 hover:border-white/50 hover:backdrop-blur-md hover:shadow-xl hover:shadow-white/10 hover:ring-1 hover:ring-white/20 before:content-[''] before:absolute before:inset-0 before:bg-gradient-to-br before:from-white/15 before:to-white/5 before:opacity-0 hover:before:opacity-100"><i class="fa-brands fa-whatsapp text-white"></i> Konsultasi Gratis</a>
        </div>
      </div>
      <div class="relative">
        <div class="rounded-xl border border-white/10 p-6 bg-white/5">
          <div class="grid grid-cols-2 gap-4">
            <div class="p-4 rounded-lg bg-black/60 border border-white/10">
              <div class="flex items-center gap-2">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M4 4h16v16H4z"/><path d="M9 9l-2 2l2 2M15 9l2 2l-2 2"/></svg>
                <span class="font-semibold">Desain Responsif</span>
              </div>
              <p class="mt-2 text-white/70">Tampilan optimal di semua perangkat.</p>
            </div>
            <div class="p-4 rounded-lg bg-black/60 border border-white/10">
              <div class="flex items-center gap-2">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 3v18"/><path d="M3 12h18"/></svg>
                <span class="font-semibold">SEO Optimized</span>
              </div>
              <p class="mt-2 text-white/70">Mudah ditemukan di mesin pencari Google.</p>
            </div>
            <div class="p-4 rounded-lg bg-black/60 border border-white/10">
              <div class="flex items-center gap-2">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M5 12l5 5L20 7"/></svg>
                <span class="font-semibold">Loading Cepat</span>
              </div>
              <p class="mt-2 text-white/70">Performa tinggi untuk pengalaman terbaik.</p>
            </div>
            <div class="p-4 rounded-lg bg-black/60 border border-white/10">
              <div class="flex items-center gap-2">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 6v6l4 2"/></svg>
                <span class="font-semibold">Support 24/7</span>
              </div>
              <p class="mt-2 text-white/70">Bantuan teknis kapan pun Anda butuhkan.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<section id="statistik" class="mt-16 py-16 bg-white/5">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="text-center mb-12">
      <h2 class="text-3xl font-bold">Pencapaian <span class="text-brand-yellow">Kami</span></h2>
      <p class="mt-4 text-white/70 max-w-3xl mx-auto">Kami bangga dengan hasil kerja dan kepercayaan yang telah diberikan oleh klien-klien kami selama ini.</p>
    </div>
    
    <div class="grid grid-cols-1 md:grid-cols-3 gap-8 text-center">
      <div class="p-8 rounded-xl bg-white/5 border border-white/10 hover:border-brand-yellow hover:bg-white/10 transition-all duration-300 transform hover:-translate-y-2">
        <div class="w-16 h-16 bg-brand-yellow/20 rounded-full flex items-center justify-center mx-auto mb-4">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-brand-yellow" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2" />
          </svg>
        </div>
        <div class="text-5xl font-bold text-brand-yellow counter-value" data-count="250">0</div>
        <div class="mt-3 text-xl text-white/80">Project Selesai</div>
      </div>
      
      <div class="p-8 rounded-xl bg-white/5 border border-white/10 hover:border-brand-yellow hover:bg-white/10 transition-all duration-300 transform hover:-translate-y-2">
        <div class="w-16 h-16 bg-brand-yellow/20 rounded-full flex items-center justify-center mx-auto mb-4">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-brand-yellow" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M14 10h4.764a2 2 0 011.789 2.894l-3.5 7A2 2 0 0115.263 21h-4.017c-.163 0-.326-.02-.485-.06L7 20m7-10V5a2 2 0 00-2-2h-.095c-.5 0-.905.405-.905.905 0 .714-.211 1.412-.608 2.006L7 11v9m7-10h-2M7 20H5a2 2 0 01-2-2v-6a2 2 0 012-2h2.5" />
          </svg>
        </div>
        <div class="text-5xl font-bold text-brand-yellow counter-value" data-count="120">0</div>
        <div class="mt-3 text-xl text-white/80">Klien Puas</div>
      </div>
      
      <div class="p-8 rounded-xl bg-white/5 border border-white/10 hover:border-brand-yellow hover:bg-white/10 transition-all duration-300 transform hover:-translate-y-2">
        <div class="w-16 h-16 bg-brand-yellow/20 rounded-full flex items-center justify-center mx-auto mb-4">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-brand-yellow" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" />
          </svg>
        </div>
        <div class="text-5xl font-bold text-brand-yellow counter-value" data-count="4.9" data-decimal="true">0</div>
        <div class="mt-3 text-xl text-white/80">Rating Klien</div>
        <div class="flex justify-center mt-3">
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
          <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
        </div>
      </div>
    </div>
  </div>
</section>

<section id="mengapa" class="mt-16">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <h2 class="text-3xl font-bold">Mengapa Memilih <span class="text-brand-yellow">CreateWeb</span>?</h2>
    <div class="mt-8 grid md:grid-cols-3 gap-6">
      <div class="p-6 rounded-xl bg-white/5 border border-white/10">
        <h3 class="font-semibold">Tim Profesional</h3>
        <p class="mt-2 text-white/70">Tim developer dan desainer berpengalaman dengan standar kualitas tinggi.</p>
      </div>
      <div class="p-6 rounded-xl bg-white/5 border border-white/10">
        <h3 class="font-semibold">Harga Transparan</h3>
        <p class="mt-2 text-white/70">Tidak ada biaya tersembunyi, Anda tahu persis apa yang Anda dapatkan.</p>
      </div>
      <div class="p-6 rounded-xl bg-white/5 border border-white/10">
        <h3 class="font-semibold">Hasil Terukur</h3>
        <p class="mt-2 text-white/70">Website yang tidak hanya indah, tapi juga memberikan hasil bisnis nyata.</p>
      </div>
    </div>
  </div>
</section>

<!-- Script untuk animasi counter -->
<script>
  document.addEventListener('DOMContentLoaded', function() {
    // Fungsi untuk menganimasikan counter
    function animateCounter() {
      const counters = document.querySelectorAll('.counter-value');
      
      counters.forEach(counter => {
        const target = parseFloat(counter.getAttribute('data-count'));
        const isDecimal = counter.getAttribute('data-decimal') === 'true';
        const duration = 2000; // Durasi animasi dalam milidetik
        const frameRate = 30; // Frame per detik
        const totalFrames = duration * frameRate / 1000;
        let frame = 0;
        
        const initialValue = 0;
        const increment = (target - initialValue) / totalFrames;
        
        // Mulai animasi
        const animation = setInterval(() => {
          frame++;
          const currentValue = initialValue + (increment * frame);
          
          if (isDecimal) {
            counter.textContent = currentValue.toFixed(1);
          } else {
            counter.textContent = Math.floor(currentValue);
            if (frame === totalFrames) counter.textContent += '+';
          }
          
          // Hentikan animasi saat selesai
          if (frame >= totalFrames) {
            clearInterval(animation);
          }
        }, 1000 / frameRate);
      });
    }
    
    // Fungsi untuk memeriksa apakah elemen terlihat di viewport
    function isElementInViewport(el) {
      const rect = el.getBoundingClientRect();
      return (
        rect.top >= 0 &&
        rect.left >= 0 &&
        rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) &&
        rect.right <= (window.innerWidth || document.documentElement.clientWidth)
      );
    }
    
    // Jalankan animasi saat elemen terlihat saat scroll
    function checkVisibility() {
      const statistikSection = document.getElementById('statistik');
      if (isElementInViewport(statistikSection)) {
        animateCounter();
        window.removeEventListener('scroll', checkVisibility);
      }
    }
    
    // Periksa visibilitas saat halaman dimuat
    checkVisibility();
    
    // Tambahkan event listener untuk scroll
    window.addEventListener('scroll', checkVisibility);
  });
</script>

<section id="layanan" class="mt-16">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <h2 class="text-3xl font-bold">Layanan Kami</h2>
    <div class="mt-8 grid md:grid-cols-2 lg:grid-cols-3 gap-6">
      <div class="p-6 rounded-xl bg-white/5 border border-white/10">
        <h3 class="font-semibold">Company Profile</h3>
        <p class="mt-2 text-white/70">Website profil perusahaan untuk memperkuat kepercayaan dan reputasi.</p>
      </div>
      <div class="p-6 rounded-xl bg-white/5 border border-white/10">
        <h3 class="font-semibold">E-Commerce</h3>
        <p class="mt-2 text-white/70">Toko online lengkap dengan katalog produk dan sistem checkout.</p>
      </div>
      <div class="p-6 rounded-xl bg-white/5 border border-white/10">
        <h3 class="font-semibold">Landing Page</h3>
        <p class="mt-2 text-white/70">Halaman penawaran khusus untuk kampanye pemasaran.</p>
      </div>
      <div class="p-6 rounded-xl bg-white/5 border border-white/10">
        <h3 class="font-semibold">Custom Development</h3>
        <p class="mt-2 text-white/70">Solusi kustom sesuai kebutuhan unik bisnis Anda.</p>
      </div>
      <div class="p-6 rounded-xl bg-white/5 border border-white/10">
        <h3 class="font-semibold">Optimasi & Maintenance</h3>
        <p class="mt-2 text-white/70">Perawatan, peningkatan performa, dan keamanan berkala.</p>
      </div>
      <div class="p-6 rounded-xl bg-white/5 border border-white/10">
        <h3 class="font-semibold">Integrasi Sistem</h3>
        <p class="mt-2 text-white/70">Integrasi API, CRM, pembayaran, dan lainnya.</p>
      </div>
    </div>
  </div>
</section>

<section id="testimonial" class="mt-16">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <h2 class="text-3xl font-bold">Apa Kata Klien Kami</h2>
    <div class="mt-8 grid md:grid-cols-3 gap-6">
      <div class="p-6 rounded-xl bg-white/5 border border-white/10">
        <div class="flex justify-between items-start">
          <div>
            <h3 class="font-semibold">Ahmad Rizki</h3>
            <p class="text-sm text-white/60">CEO, Bintang Furniture</p>
          </div>
          <div class="flex">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
          </div>
        </div>
        <p class="mt-4 text-white/80">"Website baru kami dari CreateWeb telah meningkatkan penjualan online sebesar 40% dalam 3 bulan pertama. Desainnya profesional dan mudah digunakan."</p>
      </div>
      <div class="p-6 rounded-xl bg-white/5 border border-white/10">
        <div class="flex justify-between items-start">
          <div>
            <h3 class="font-semibold">Siti Nurhaliza</h3>
            <p class="text-sm text-white/60">Founder, Batik Nusantara</p>
          </div>
          <div class="flex">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
          </div>
        </div>
        <p class="mt-4 text-white/80">"Proses pengembangan sangat profesional dan tepat waktu. Tim CreateWeb sangat responsif dan memahami kebutuhan bisnis kami dengan baik."</p>
      </div>
      <div class="p-6 rounded-xl bg-white/5 border border-white/10">
        <div class="flex justify-between items-start">
          <div>
            <h3 class="font-semibold">Budi Santoso</h3>
            <p class="text-sm text-white/60">Marketing Director, Griya Property</p>
          </div>
          <div class="flex">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 text-brand-yellow" viewBox="0 0 20 20" fill="currentColor"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
          </div>
        </div>
        <p class="mt-4 text-white/80">"Investasi terbaik untuk bisnis properti kami. Website yang dibuat CreateWeb telah menghasilkan 60+ leads baru setiap bulannya. Sangat puas!"</p>
      </div>
    </div>
  </div>
</section>