<?php
$settings = isset($settings) ? $settings : ($_SESSION['settings_general'] ?? [
  'site_name' => 'CreateWeb',
  'email' => 'info@createweb.com',
  'whatsapp_number' => '+62 812-3456-7890',
  'address' => 'Jl. Contoh No. 123, Jakarta',
  'work_hours' => 'Senin - Jumat: 09:00 - 17:00',
]);
$waDigits = preg_replace('/\D+/', '', $settings['whatsapp_number'] ?? '');
?>
<section class="py-16">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="text-center mb-12">
      <h1 class="text-5xl font-bold mb-4">Hubungi <span class="text-brand-yellow">Kami</span></h1>
      <p class="text-xl text-white/70 max-w-3xl mx-auto">Kami siap membantu mewujudkan website impian Anda. Hubungi kami untuk konsultasi gratis atau kirimkan pesan melalui form di bawah ini.</p>
    </div>
    
    <!-- Card Kontak sederhana tanpa animasi hover berlebihan -->
    <div class="grid md:grid-cols-3 gap-6 mb-16">
      <!-- Card WhatsApp -->
      <div class="bg-white/5 p-6 rounded-xl border border-white/10 hover:border-brand-yellow">
        <div class="flex items-center mb-4">
          <div class="flex-shrink-0 h-12 w-12 bg-brand-yellow/20 rounded-full flex items-center justify-center text-brand-yellow mr-4">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12.031 6.172c-3.181 0-5.767 2.586-5.768 5.766-.001 1.298.38 2.27 1.019 3.287l-.582 2.128 2.182-.573c.978.58 1.911.928 3.145.929 3.178 0 5.767-2.587 5.768-5.766.001-3.187-2.575-5.77-5.764-5.771zm3.392 8.244c-.144.405-.837.774-1.17.824-.299.045-.677.063-1.092-.069-.252-.08-.575-.187-.988-.365-1.739-.751-2.874-2.502-2.961-2.617-.087-.116-.708-.94-.708-1.793s.448-1.273.607-1.446c.159-.173.346-.217.462-.217l.332.006c.106.005.249-.04.39.298.144.347.491 1.2.534 1.287.043.087.072.188.014.304-.058.116-.087.188-.173.289l-.26.304c-.087.086-.177.18-.076.354.101.174.449.741.964 1.201.662.591 1.221.774 1.394.86s.274.072.376-.043c.101-.116.433-.506.549-.68.116-.173.231-.145.39-.087s1.011.477 1.184.564.289.13.332.202c.045.72.045.419-.1.824zm-3.423-14.416c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm.029 18.88c-1.161 0-2.305-.292-3.318-.844l-3.677.964.984-3.595c-.607-1.052-.927-2.246-.926-3.468.001-3.825 3.113-6.937 6.937-6.937 1.856.001 3.598.723 4.907 2.034 1.31 1.311 2.031 3.054 2.03 4.908-.001 3.825-3.113 6.938-6.937 6.938z"/>
            </svg>
          </div>
          <div>
            <h3 class="font-bold text-xl">WhatsApp</h3>
            <p class="text-white/70">Chat langsung dengan kami</p>
          </div>
        </div>
        <a href="https://wa.me/<?= htmlspecialchars($waDigits ?: '6281234567890') ?>" class="text-lg text-brand-yellow hover:underline" target="_blank" rel="noopener">
          <?= htmlspecialchars($settings['whatsapp_number'] ?? '+62 812-3456-7890') ?>
        </a>
      </div>
      
      <!-- Card Email -->
      <div class="bg-white/5 p-6 rounded-xl border border-white/10 hover:border-brand-yellow">
        <div class="flex items-center mb-4">
          <div class="flex-shrink-0 h-12 w-12 bg-brand-yellow/20 rounded-full flex items-center justify-center text-brand-yellow mr-4">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 .02c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm6.99 6.98l-6.99 5.666-6.991-5.666h13.981zm.01 10h-14v-8.505l7 5.673 7-5.672v8.504z"/>
            </svg>
          </div>
          <div>
            <h3 class="font-bold text-xl">Email</h3>
            <p class="text-white/70">Kirim email kepada kami</p>
          </div>
        </div>
        <a href="mailto:<?= htmlspecialchars($settings['email'] ?? 'info@createweb.com') ?>" class="text-lg text-brand-yellow hover:underline">
          <?= htmlspecialchars($settings['email'] ?? 'info@createweb.com') ?>
        </a>
      </div>
      
      <!-- Card Jam Kerja -->
      <div class="bg-white/5 p-6 rounded-xl border border-white/10 hover:border-brand-yellow">
        <div class="flex items-center mb-4">
          <div class="flex-shrink-0 h-12 w-12 bg-brand-yellow/20 rounded-full flex items-center justify-center text-brand-yellow mr-4">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="currentColor" viewBox="0 0 24 24">
              <path d="M12 0c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm6 14h-7v-8h2v6h5v2z"/>
            </svg>
          </div>
          <div>
            <h3 class="font-bold text-xl">Jam Kerja</h3>
            <p class="text-white/70">Waktu operasional kami</p>
          </div>
        </div>
        <p class="text-lg whitespace-pre-line"><?= htmlspecialchars($settings['work_hours'] ?? 'Senin - Jumat: 09:00 - 17:00') ?></p>
      </div>
    </div>
    
    <div class="grid md:grid-cols-2 gap-12">
      <!-- Kolom Kiri: Alamat + Peta -->
      <div>
        <div class="bg-white/5 p-6 rounded-xl border border-white/10 mb-8">
          <h2 class="text-2xl font-semibold mb-4">Alamat Kami</h2>
          <div class="flex items-start mb-4">
            <div class="flex-shrink-0 h-6 w-6 text-brand-yellow mr-3">
              <svg xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 24 24">
                <path d="M12 0c-4.198 0-8 3.403-8 7.602 0 4.198 3.469 9.21 8 16.398 4.531-7.188 8-12.2 8-16.398 0-4.199-3.801-7.602-8-7.602zm0 11c-1.657 0-3-1.343-3-3s1.343-3 3-3 3 1.343 3 3-1.343 3-3 3z" />
              </svg>
            </div>
            <div>
              <p class="text-white/70"><?= htmlspecialchars($settings['address'] ?? 'Jl. Contoh No. 123, Jakarta') ?></p>
            </div>
          </div>
          
          <!-- Peta Lokasi -->
          <div class="w-full h-64 bg-white/10 rounded-lg overflow-hidden relative">
            <iframe class="w-full h-full" src="https://www.google.com/maps/embed?pb=!1m13!1m11!1m3!1d83.70697010015952!2d108.69080307608444!3d-7.540147978956593!2m2!1f0!2f3.224433457189625!3m2!1i1024!2i768!4f54.068290375756646!5e1!3m2!1sid!2sid!4v1759554967017!5m2!1sid!2sid" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
          </div>
        </div>
        
        <div class="bg-white/5 p-6 rounded-xl border border-white/10">
          <h2 class="text-2xl font-bold mb-4">Informasi Kontak</h2>
          
          <div class="space-y-4">
            <!-- Email -->
            <div class="flex items-center">
              <div class="flex-shrink-0 h-10 w-10 bg-brand-yellow/20 rounded-full flex items-center justify-center text-brand-yellow mr-3">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M12 .02c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm6.99 6.98l-6.99 5.666-6.991-5.666h13.981zm.01 10h-14v-8.505l7 5.673 7-5.672v8.504z"/>
                </svg>
              </div>
              <div>
                <p class="text-sm text-white/70">Email</p>
                <a href="mailto:<?= htmlspecialchars($settings['email'] ?? 'info@createweb.com') ?>" class="text-brand-yellow hover:underline">
                  <?= htmlspecialchars($settings['email'] ?? 'info@createweb.com') ?>
                </a>
              </div>
            </div>

            <!-- WhatsApp -->
            <div class="flex items-center">
              <div class="flex-shrink-0 h-10 w-10 bg-brand-yellow/20 rounded-full flex items-center justify-center text-brand-yellow mr-3">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M12.031 6.172c-3.181 0-5.767 2.586-5.768 5.766-.001 1.298.38 2.27 1.019 3.287l-.582 2.128 2.182-.573c.978.58 1.911.928 3.145.929 3.178 0 5.767-2.587 5.768-5.766.001-3.187-2.575-5.77-5.764-5.771zm3.392 8.244c-.144.405-.837.774-1.17.824-.299.045-.677.063-1.092-.069-.252-.08-.575-.187-.988-.365-1.739-.751-2.874-2.502-2.961-2.617-.087-.116-.708-.94-.708-1.793s.448-1.273.607-1.446c.159-.173.346-.217.462-.217l.332.006c.106.005.249-.04.39.298.144.347.491 1.2.534 1.287.043.087.072.188.014.304-.058.116-.087.188-.173.289l-.26.304c-.087.086-.177.18-.076.354.101.174.449.741.964 1.201.662.591 1.221.774 1.394.86s.274.072.376-.043c.101-.116.433-.506.549-.68.116-.173.231-.145.39-.087s1.011.477 1.184.564.289.13.332.202c.045.72.045.419-.1.824zm-3.423-14.416c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm.029 18.88c-1.161 0-2.305-.292-3.318-.844l-3.677.964.984-3.595c-.607-1.052-.927-2.246-.926-3.468.001-3.825 3.113-6.937 6.937-6.937 1.856.001 3.598.723 4.907 2.034 1.31 1.311 2.031 3.054 2.03 4.908-.001 3.825-3.113 6.938-6.937 6.938z"/>
                </svg>
              </div>
              <div>
                <p class="text-sm text-white/70">WhatsApp</p>
                <a href="https://wa.me/<?= htmlspecialchars($waDigits ?: '6281234567890') ?>" target="_blank" rel="noopener" class="text-brand-yellow hover:underline">
                  <?= htmlspecialchars($settings['whatsapp_number'] ?? '+62 812-3456-7890') ?>
                </a>
              </div>
            </div>

            <!-- Instagram -->
            <?php if (!empty($settings['instagram'])): ?>
            <div class="flex items-center">
              <div class="flex-shrink-0 h-10 w-10 bg-brand-yellow/20 rounded-full flex items-center justify-center text-brand-yellow mr-3">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M12 2.163c3.204 0 3.584.012 4.85.07 3.252.148 4.771 1.691 4.919 4.919.058 1.265.069 1.645.069 4.849 0 3.205-.012 3.584-.069 4.849-.149 3.225-1.664 4.771-4.919 4.919-1.266.058-1.644.07-4.85.07-3.204 0-3.584-.012-4.849-.07-3.26-.149-4.771-1.699-4.919-4.92-.058-1.265-.07-1.644-.07-4.849 0-3.204.013-3.583.07-4.849.149-3.227 1.664-4.771 4.919-4.919 1.266-.057 1.645-.069 4.849-.069zm0-2.163c-3.259 0-3.667.014-4.947.072-4.358.2-6.78 2.618-6.98 6.98-.059 1.281-.073 1.689-.073 4.948 0 3.259.014 3.668.072 4.948.2 4.358 2.618 6.78 6.98 6.98 1.281.058 1.689.072 4.948.072 3.259 0 3.668-.014 4.948-.072 4.354-.2 6.782-2.618 6.979-6.98.059-1.28.073-1.689.073-4.948 0-3.259-.014-3.667-.072-4.947-.196-4.354-2.617-6.78-6.979-6.98-1.281-.059-1.69-.073-4.949-.073zm0 5.838c-3.403 0-6.162 2.759-6.162 6.162s2.759 6.163 6.162 6.163 6.162-2.759 6.162-6.163c0-3.403-2.759-6.162-6.162-6.162zm0 10.162c-2.209 0-4-1.79-4-4 0-2.209 1.791-4 4-4s4 1.791 4 4c0 2.21-1.791 4-4 4zm6.406-11.845c-.796 0-1.441.645-1.441 1.44s.645 1.44 1.441 1.44c.795 0 1.439-.645 1.439-1.44s-.644-1.44-1.439-1.44z"/>
                </svg>
              </div>
              <div>
                <p class="text-sm text-white/70">Instagram</p>
                <a href="https://instagram.com/<?= htmlspecialchars(ltrim($settings['instagram'], '@')) ?>" target="_blank" rel="noopener" class="text-brand-yellow hover:underline">
                  <?= htmlspecialchars($settings['instagram']) ?>
                </a>
              </div>
            </div>
            <?php endif; ?>

            <!-- TikTok -->
            <?php if (!empty($settings['tiktok'])): ?>
            <div class="flex items-center">
              <div class="flex-shrink-0 h-10 w-10 bg-brand-yellow/20 rounded-full flex items-center justify-center text-brand-yellow mr-3">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M12.525.02c1.31-.02 2.61-.01 3.91-.02.08 1.53.63 3.09 1.75 4.17 1.12 1.11 2.7 1.62 4.24 1.79v4.03c-1.44-.05-2.89-.35-4.2-.97-.57-.26-1.1-.59-1.62-.93-.01 2.92.01 5.84-.02 8.75-.08 1.4-.54 2.79-1.35 3.94-1.31 1.92-3.58 3.17-5.91 3.21-1.43.08-2.86-.31-4.08-1.03-2.02-1.19-3.44-3.37-3.65-5.71-.02-.5-.03-1-.01-1.49.18-1.9 1.12-3.72 2.58-4.96 1.66-1.44 3.98-2.13 6.15-1.72.02 1.48-.04 2.96-.04 4.44-.99-.32-2.15-.23-3.02.37-.63.41-1.11 1.04-1.36 1.75-.21.51-.15 1.07-.14 1.61.24 1.64 1.82 3.02 3.5 2.87 1.12-.01 2.19-.66 2.77-1.61.19-.33.4-.67.41-1.06.1-1.79.06-3.57.07-5.36.01-4.03-.01-8.05.02-12.07z"/>
                </svg>
              </div>
              <div>
                <p class="text-sm text-white/70">TikTok</p>
                <a href="https://tiktok.com/<?= htmlspecialchars(ltrim($settings['tiktok'], '@')) ?>" target="_blank" rel="noopener" class="text-brand-yellow hover:underline">
                  <?= htmlspecialchars($settings['tiktok']) ?>
                </a>
              </div>
            </div>
            <?php endif; ?>
          </div>
        </div>
      </div>

      <!-- Kolom Kanan: Form Kontak -->
      <div>
        <div class="bg-white/5 p-8 rounded-xl border border-white/10">
          <h2 class="text-2xl font-semibold mb-6">Kirim Pesan</h2>

          <?php if (isset($success) && $success): ?>
          <div class="bg-green-500/20 border border-green-500/30 text-green-300 px-4 py-3 rounded-lg mb-6">
            <?= $success ?>
          </div>
          <?php endif; ?>

          <?php if (isset($error) && $error): ?>
          <div class="bg-red-500/20 border border-red-500/30 text-red-300 px-4 py-3 rounded-lg mb-6">
            <?= $error ?>
          </div>
          <?php endif; ?>

          <form id="form-konsultasi" action="/kontak/kirim" method="POST">
            <div class="grid md:grid-cols-2 gap-6 mb-6">
              <div>
                <label for="name" class="block text-sm font-medium text-white/70 mb-2">Nama Lengkap</label>
                <input type="text" name="name" id="name" required minlength="3" pattern="^[A-Za-zÀ-ÖØ-öø-ÿ'\-\s]{3,}$" class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-3 text-white focus:outline-none focus:ring-2 focus:ring-brand-yellow/50 focus:border-brand-yellow/50" placeholder="Masukkan nama lengkap Anda">
                <p id="nameError" class="text-red-500 text-sm mt-1 hidden"></p>
              </div>
              <div>
                <label for="email" class="block text-sm font-medium text-white/70 mb-2">Email</label>
                <input type="email" name="email" id="email" required pattern="^[^\s@]+@[^\s@]+\.[^\s@]+$" class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-3 text-white focus:outline-none focus:ring-2 focus:ring-brand-yellow/50 focus:border-brand-yellow/50" placeholder="Masukkan alamat email Anda">
                <p id="emailError" class="text-red-500 text-sm mt-1 hidden"></p>
              </div>
            </div>
            
            <div class="mb-6">
              <label for="subject" class="block text-sm font-medium text-white/70 mb-2">Subjek</label>
              <input type="text" name="subject" id="subject" required minlength="3" class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-3 text-white focus:outline-none focus:ring-2 focus:ring-brand-yellow/50 focus:border-brand-yellow/50" placeholder="Subjek pesan Anda">
              <p id="subjectError" class="text-red-500 text-sm mt-1 hidden"></p>
            </div>
            
            <div class="mb-6">
              <label for="message" class="block text-sm font-medium text-white/70 mb-2">Pesan</label>
              <textarea name="message" id="message" rows="5" required minlength="10" class="w-full bg-white/5 border border-white/10 rounded-lg px-4 py-3 text-white focus:outline-none focus:ring-2 focus:ring-brand-yellow/50 focus:border-brand-yellow/50" placeholder="Tulis pesan Anda di sini..."></textarea>
              <p id="messageError" class="text-red-500 text-sm mt-1 hidden"></p>
            </div>
            
            <div>
              <button type="submit" class="inline-flex items-center px-6 py-3 border border-transparent text-base font-medium rounded-md shadow-sm text-gray-900 bg-brand-yellow hover:bg-brand-yellow/90 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-brand-yellow/70 transition-all duration-300">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" fill="currentColor" viewBox="0 0 24 24">
                  <path d="M24 0l-6 22-8.129-7.239 7.802-8.234-10.458 7.227-7.215-1.754 24-12zm-15 16.668v7.332l3.258-4.431-3.258-2.901z"/>
                </svg>
                Kirim Pesan
              </button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- Hapus script animasi scroll untuk kesederhanaan tampilan -->
<!-- (tidak ada script animasi scroll) -->

<script>
  document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('form[action="/kontak/kirim"]');
    if (!form) return;
    const name = form.querySelector('#name');
    const email = form.querySelector('#email');
    const subject = form.querySelector('#subject');
    const message = form.querySelector('#message');
    const submitBtn = form.querySelector('button[type="submit"]');

    const errors = {
      name: form.querySelector('#nameError'),
      email: form.querySelector('#emailError'),
      subject: form.querySelector('#subjectError'),
      message: form.querySelector('#messageError'),
    };

    function showError(input, errorEl, msg) {
      if (!errorEl) return;
      errorEl.textContent = msg;
      errorEl.classList.remove('hidden');
      input.classList.add('border-red-500');
    }
    function clearError(input, errorEl) {
      if (!errorEl) return;
      errorEl.textContent = '';
      errorEl.classList.add('hidden');
      input.classList.remove('border-red-500');
    }

    function validateName() {
      const val = name.value.trim();
      if (val.length < 3) { showError(name, errors.name, 'Nama minimal 3 karakter'); return false; }
      clearError(name, errors.name); return true;
    }
    function validateEmail() {
      const val = email.value.trim();
      const re = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
      if (!val) { showError(email, errors.email, 'Email wajib diisi'); return false; }
      if (!re.test(val)) { showError(email, errors.email, 'Format email tidak valid'); return false; }
      clearError(email, errors.email); return true;
    }
    function validateSubject() {
      const val = subject.value.trim();
      if (val.length < 3) { showError(subject, errors.subject, 'Subjek minimal 3 karakter'); return false; }
      clearError(subject, errors.subject); return true;
    }
    function validateMessage() {
      const val = message.value.trim();
      if (val.length < 10) { showError(message, errors.message, 'Pesan minimal 10 karakter'); return false; }
      clearError(message, errors.message); return true;
    }

    const map = { name, email, subject, message };
    const handlers = { name: validateName, email: validateEmail, subject: validateSubject, message: validateMessage };
    Object.entries(handlers).forEach(([key, fn]) => {
      const input = map[key];
      input.addEventListener('input', fn);
      input.addEventListener('blur', fn);
    });

    let submitting = false;
    form.addEventListener('submit', function(e) {
      if (submitting) { e.preventDefault(); return; }
      const ok = [validateName(), validateEmail(), validateSubject(), validateMessage()].every(Boolean);
      if (!ok) { e.preventDefault(); return; }
      submitting = true;
      const original = submitBtn.innerHTML;
      submitBtn.disabled = true;
      submitBtn.classList.add('opacity-70', 'cursor-not-allowed');
      submitBtn.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2 animate-spin" viewBox="0 0 24 24"><circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="2" fill="none" class="opacity-25"/><path d="M4 12a8 8 0 018-8" stroke="currentColor" stroke-width="2" fill="none" class="opacity-75"/></svg> Mengirim...';
      setTimeout(() => {
        submitting = false;
        submitBtn.disabled = false;
        submitBtn.classList.remove('opacity-70', 'cursor-not-allowed');
        submitBtn.innerHTML = original;
      }, 15000);
    });
  });
</script>