<?php
$title = 'Pengaturan Umum';
?>

<div class="bg-white rounded-lg shadow-md overflow-hidden">
    <div class="p-4 border-b bg-gradient-to-r from-blue-50 to-indigo-50 flex justify-between items-center">
        <div class="flex items-center gap-2">
            <i class="fas fa-sliders-h text-blue-500"></i>
            <h3 class="text-lg font-semibold text-gray-800">Pengaturan Umum</h3>
        </div>
        <!-- Tautan ke tampilan dihapus sesuai permintaan -->
    </div>
    <div class="p-6">
        <?php if (!empty($_SESSION['success'])): ?>
            <div class="mb-4 p-3 rounded bg-green-50 text-green-700 text-sm flex items-center gap-2">
                <i class="fas fa-check-circle"></i>
                <span><?= $_SESSION['success']; unset($_SESSION['success']); ?></span>
            </div>
        <?php endif; ?>
        <form action="/admin/settings/general" method="post" class="space-y-4">
            <div>
                <label for="site_name" class="block text-sm font-medium text-gray-700">Nama Website</label>
                <input type="text" id="site_name" name="site_name" value="<?= htmlspecialchars($general['site_name'] ?? '') ?>" class="mt-1 w-full border rounded px-3 py-2 text-gray-700 focus:ring-2 focus:ring-blue-300 focus:outline-none" required>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700">Email</label>
                    <input type="email" id="email" name="email" value="<?= htmlspecialchars($general['email'] ?? '') ?>" class="mt-1 w-full border rounded px-3 py-2 text-gray-700 focus:ring-2 focus:ring-blue-300 focus:outline-none" required>
                </div>
                <div>
                    <label for="address" class="block text-sm font-medium text-gray-700">Alamat</label>
                    <input type="text" id="address" name="address" value="<?= htmlspecialchars($general['address'] ?? '') ?>" class="mt-1 w-full border rounded px-3 py-2 text-gray-700 focus:ring-2 focus:ring-blue-300 focus:outline-none" required>
                </div>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label for="whatsapp_number" class="block text-sm font-medium text-gray-700">No WhatsApp</label>
                    <div class="mt-1 flex rounded-md shadow-sm">
                        <span class="inline-flex items-center px-3 rounded-l-md border border-r-0 border-gray-300 bg-gray-50 text-gray-500 text-sm">
                            +62
                        </span>
                        <input type="text" id="whatsapp_number" name="whatsapp_number" 
                            value="<?= htmlspecialchars(preg_replace('/^\+62/', '', $general['whatsapp_number'] ?? '')) ?>" 
                            class="flex-1 min-w-0 block w-full px-3 py-2 rounded-none rounded-r-md border focus:ring-2 focus:ring-blue-300 focus:outline-none text-gray-700" 
                            placeholder="8123456789" 
                            required>
                    </div>
                    <p class="mt-1 text-sm text-gray-500">Masukkan nomor tanpa angka 0 di depan (contoh: 8123456789)</p>
                </div>
                <div class="flex flex-col">
                    <label for="work_hours" class="block text-sm font-medium text-gray-700">Jam Kerja</label>
                    <textarea id="work_hours" name="work_hours" rows="3" class="mt-1 w-full border rounded px-3 py-2 text-gray-700 focus:ring-2 focus:ring-blue-300 focus:outline-none" placeholder="Contoh: Senin - Jumat: 09:00 - 17:00&#10;Sabtu: 10:00 - 14:00"><?= htmlspecialchars($general['work_hours'] ?? '') ?></textarea>
                </div>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label for="instagram" class="block text-sm font-medium text-gray-700">Instagram</label>
                    <input type="text" id="instagram" name="instagram" value="<?= htmlspecialchars($general['instagram'] ?? '') ?>" class="mt-1 w-full border rounded px-3 py-2 text-gray-700 focus:ring-2 focus:ring-blue-300 focus:outline-none" placeholder="@username">
                </div>
                <div>
                    <label for="tiktok" class="block text-sm font-medium text-gray-700">TikTok</label>
                    <input type="text" id="tiktok" name="tiktok" value="<?= htmlspecialchars($general['tiktok'] ?? '') ?>" class="mt-1 w-full border rounded px-3 py-2 text-gray-700 focus:ring-2 focus:ring-blue-300 focus:outline-none" placeholder="@username">
                </div>
            </div>
            <div class="flex items-center justify-end gap-3 pt-4">
                <a href="/admin/dashboard" class="text-sm text-gray-500 hover:text-gray-700">Batal</a>
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white text-sm font-medium px-4 py-2 rounded shadow">Simpan</button>
            </div>
        </form>
    </div>
</div>

<?php
require_once __DIR__ . '/../../layouts/admin.php';
?>