<?php
$title = 'Pengaturan Tampilan';
?>
<div class="bg-white rounded-lg shadow-md overflow-hidden">
    <div class="p-4 border-b bg-gradient-to-r from-indigo-50 to-purple-50 flex justify-between items-center">
        <div class="flex items-center gap-2">
            <i class="fas fa-palette text-indigo-500"></i>
            <h3 class="text-lg font-semibold text-gray-800">Pengaturan Tampilan</h3>
        </div>
        <a href="/admin/settings/general" class="text-xs text-blue-600 hover:text-blue-800">Ke Pengaturan Umum</a>
    </div>
    <div class="p-6">
        <?php if (!empty($_SESSION['success'])): ?>
            <div class="mb-4 p-3 rounded bg-green-50 text-green-700 text-sm flex items-center gap-2">
                <i class="fas fa-check-circle"></i>
                <span><?= $_SESSION['success']; unset($_SESSION['success']); ?></span>
            </div>
        <?php endif; ?>
        <form action="/admin/settings/appearance" method="post" class="space-y-4">
            <div>
                <label for="theme_color" class="block text-sm font-medium text-gray-700">Warna Tema</label>
                <select id="theme_color" name="theme_color" class="mt-1 w-full border rounded px-3 py-2 text-gray-700 focus:ring-2 focus:ring-indigo-300 focus:outline-none">
                    <?php
                        $options = ['blue' => 'Biru', 'indigo' => 'Indigo', 'emerald' => 'Hijau Emerald', 'violet' => 'Ungu Violet', 'rose' => 'Merah Rose'];
                        foreach ($options as $val => $label) {
                            $selected = ($appearance['theme_color'] ?? 'blue') === $val ? 'selected' : '';
                            echo "<option value=\"$val\" $selected>$label</option>";
                        }
                    ?>
                </select>
            </div>
            <div>
                <label for="layout" class="block text-sm font-medium text-gray-700">Layout</label>
                <select id="layout" name="layout" class="mt-1 w-full border rounded px-3 py-2 text-gray-700 focus:ring-2 focus:ring-indigo-300 focus:outline-none">
                    <?php
                        $layouts = ['sidebar' => 'Sidebar Kiri', 'topbar' => 'Topbar'];
                        foreach ($layouts as $val => $label) {
                            $selected = ($appearance['layout'] ?? 'sidebar') === $val ? 'selected' : '';
                            echo "<option value=\"$val\" $selected>$label</option>";
                        }
                    ?>
                </select>
                <p class="text-xs text-gray-500 mt-1">Catatan: Saat ini layout yang aktif adalah Sidebar.</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label for="logo_url" class="block text-sm font-medium text-gray-700">URL Logo</label>
                    <input type="text" id="logo_url" name="logo_url" value="<?= htmlspecialchars($appearance['logo_url']) ?>" class="mt-1 w-full border rounded px-3 py-2 text-gray-700 focus:ring-2 focus:ring-indigo-300 focus:outline-none" placeholder="/assets/logo.svg">
                </div>
                <div>
                    <label for="favicon_url" class="block text-sm font-medium text-gray-700">URL Favicon</label>
                    <input type="text" id="favicon_url" name="favicon_url" value="<?= htmlspecialchars($appearance['favicon_url']) ?>" class="mt-1 w-full border rounded px-3 py-2 text-gray-700 focus:ring-2 focus:ring-indigo-300 focus:outline-none" placeholder="/assets/favicon.ico">
                </div>
            </div>
            <div class="flex items-center justify-end gap-3 pt-4">
                <a href="/admin/dashboard" class="text-sm text-gray-500 hover:text-gray-700">Batal</a>
                <button type="submit" class="bg-indigo-600 hover:bg-indigo-700 text-white text-sm font-medium px-4 py-2 rounded shadow">Simpan</button>
            </div>
        </form>
    </div>
</div>
<?php
require_once __DIR__ . '/../../layouts/admin.php';
?>