<?php
$title = "Detail Pesan";

ob_start();
?>
<div class="p-4">
  <div class="bg-white rounded-2xl border border-gray-200 shadow-lg hover:shadow-xl transition-shadow overflow-hidden">
    <div class="px-6 py-5 bg-gradient-to-r from-blue-50 to-indigo-50 border-b border-gray-200 flex items-center justify-between">
      <div>
        <h2 class="text-xl font-bold text-gray-900">Detail Pesan</h2>
        <p class="text-sm text-gray-600">Panel Admin CreateWeb</p>
      </div>
      <a href="/admin/messages" class="inline-flex items-center px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-all duration-200 shadow-sm">
        <i class="fas fa-arrow-left mr-2"></i>
        Kembali
      </a>
    </div>

    <div class="p-6">
      <?php if (isset($_SESSION['success'])) : ?>
        <div class="bg-green-100 border border-green-200 text-green-800 px-4 py-3 rounded-lg mb-4">
          <?= $_SESSION['success'] ?>
        </div>
        <?php unset($_SESSION['success']); ?>
      <?php endif; ?>

      <?php if (isset($_SESSION['error'])) : ?>
        <div class="bg-red-100 border border-red-200 text-red-800 px-4 py-3 rounded-lg mb-4">
          <?= $_SESSION['error'] ?>
        </div>
        <?php unset($_SESSION['error']); ?>
      <?php endif; ?>

      <div class="mb-6 pb-5 border-b border-gray-200">
        <div class="flex items-center justify-between">
          <div class="space-y-2">
            <h3 class="text-xl font-bold text-gray-900">
              <?= htmlspecialchars($message['subject']) ?>
            </h3>
            <div class="flex items-center text-sm text-gray-700">
              <i class="fas fa-user mr-2"></i>
              <span><strong>Dari:</strong> <?= htmlspecialchars($message['name']) ?> (<?= htmlspecialchars($message['email']) ?>)</span>
            </div>
            <div class="flex items-center text-sm text-gray-600">
              <i class="fas fa-clock mr-2"></i>
              <span><strong>Tanggal:</strong> <?= date('d M Y H:i', strtotime($message['created_at'])) ?></span>
            </div>
          </div>
          <div>
            <?php if ($message['is_replied'] == 1) : ?>
              <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                <i class="fas fa-check-circle mr-1"></i> Sudah Dibalas
              </span>
            <?php elseif ($message['is_read'] == 1) : ?>
              <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                <i class="fas fa-eye mr-1"></i> Sudah Dibaca
              </span>
            <?php else : ?>
              <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800">
                <i class="fas fa-hourglass-half mr-1"></i> Belum Dibalas
              </span>
            <?php endif; ?>
          </div>
        </div>
      </div>

      <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
        <div class="p-5 bg-slate-50 rounded-xl border border-gray-200 hover:border-gray-300 transition-colors">
          <h4 class="text-sm font-semibold text-gray-800 mb-3 flex items-center">
            <i class="fas fa-envelope-open-text mr-2 text-gray-600"></i>
            Isi Pesan
          </h4>
          <div class="text-gray-900 leading-relaxed">
            <?= nl2br(htmlspecialchars($message['message'])) ?>
          </div>
        </div>

        <?php if ($message['is_replied'] == 1) : ?>
          <div class="p-5 bg-blue-50 rounded-xl border border-blue-200">
            <h4 class="text-sm font-semibold text-gray-800 mb-3 flex items-center"><i class="fas fa-reply mr-2 text-blue-600"></i>Balasan</h4>
            <div class="flex items-center text-sm text-blue-700 mb-2">
              <i class="fas fa-reply mr-2"></i>
              <span><strong>Tanggal Balas:</strong> <?= date('d M Y H:i', strtotime($message['reply_date'])) ?></span>
            </div>
            <div class="text-gray-900 leading-relaxed">
              <?= nl2br(htmlspecialchars($message['reply'])) ?>
            </div>
          </div>
        <?php else : ?>
          <div>
            <h4 class="text-sm font-semibold text-gray-800 mb-3 flex items-center"><i class="fas fa-paper-plane mr-2 text-blue-600"></i>Balas Pesan</h4>
            <div class="p-5 bg-white rounded-xl border border-gray-200">
              <form action="/admin/messages/reply" method="post" class="space-y-4">
                <input type="hidden" name="message_id" value="<?= $message['id'] ?>">
                <div>
                  <textarea name="reply" rows="5" class="w-full px-4 py-3 border border-gray-300 rounded-xl shadow-sm focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-blue-500" placeholder="Tulis balasan Anda di sini..." required></textarea>
                </div>
                <div class="flex justify-end">
                  <button type="submit" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-all duration-200">
                    <i class="fas fa-paper-plane mr-2"></i>
                    Kirim Balasan
                  </button>
                </div>
              </form>
            </div>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<?php
$content_html = ob_get_clean();
$content = function() use ($content_html) { echo $content_html; };
include_once __DIR__ . '/../../layouts/admin.php';
?>