<?php 
$title = 'Daftar Pesan Customer';
$content = function() use ($messages) { 
?>
<div class="bg-white rounded-lg shadow-md overflow-hidden">
    <div class="p-4 border-b bg-gradient-to-r from-blue-50 to-indigo-50 flex justify-between items-center">
        <div class="flex items-center gap-2">
            <i class="fas fa-envelope-open text-blue-500"></i>
            <h3 class="text-lg font-semibold text-gray-800">Daftar Pesan Customer</h3>
        </div>
        <div class="text-xs text-gray-500">Klik "Lihat Detail" untuk membuka pesan</div>
    </div>
    <div class="p-4">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-600 uppercase tracking-wider">Pengirim</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-600 uppercase tracking-wider">Subjek</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-600 uppercase tracking-wider">Tanggal</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-600 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-6 py-3 text-right text-xs font-medium text-gray-600 uppercase tracking-wider">Aksi</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php if (empty($messages)) : ?>
                        <tr>
                            <td colspan="5" class="px-6 py-4 text-center text-sm text-gray-500">Belum ada pesan</td>
                        </tr>
                    <?php else : ?>
                        <?php foreach ($messages as $message) : ?>
                            <tr class="transition <?php echo ($message['is_read'] == 0) ? 'bg-blue-50' : 'hover:bg-gray-50'; ?>">
                                <td class="px-6 py-4">
                                    <div>
                                        <div class="text-sm font-semibold text-gray-900"><?php echo htmlspecialchars($message['name']); ?></div>
                                        <div class="text-xs text-gray-500"><?php echo htmlspecialchars($message['email']); ?></div>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="flex items-center gap-2 text-sm text-gray-800">
                                        <?php if ($message['is_read'] == 0): ?>
                                            <span class="inline-flex items-center px-2 py-0.5 rounded-full bg-blue-100 text-blue-700 text-xs font-semibold">
                                                <i class="fas fa-star mr-1"></i> Baru
                                            </span>
                                        <?php endif; ?>
                                        <span><?php echo htmlspecialchars($message['subject']); ?></span>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="text-xs text-gray-500"><?php echo date('d M Y H:i', strtotime($message['created_at'])); ?></div>
                                </td>
                                <td class="px-6 py-4">
                                    <?php if ($message['is_replied'] == 1) : ?>
                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full bg-green-100 text-green-700 text-xs font-semibold">
                                            <i class="fas fa-check-circle mr-1"></i> Sudah Dibalas
                                        </span>
                                    <?php elseif ($message['is_read'] == 1) : ?>
                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full bg-blue-100 text-blue-700 text-xs font-semibold">
                                            <i class="fas fa-eye mr-1"></i> Sudah Dibaca
                                        </span>
                                    <?php else : ?>
                                        <span class="inline-flex items-center px-2 py-0.5 rounded-full bg-yellow-100 text-yellow-700 text-xs font-semibold">
                                            <i class="fas fa-hourglass-half mr-1"></i> Belum Dibaca
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 text-right">
                                    <a href="/admin/messages/view/<?php echo $message['id']; ?>" class="inline-flex items-center text-blue-600 hover:text-blue-800 text-xs font-semibold">
                                        <i class="fas fa-search mr-1"></i> Lihat Detail
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php 
}; 
include_once __DIR__ . '/../../layouts/admin.php';
?>