<div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
    <!-- Card Statistik 1 -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex items-center">
            <div class="p-3 rounded-full bg-blue-100 text-blue-500 mr-4">
                <i class="fas fa-users text-xl"></i>
            </div>
            <div>
                <p class="text-gray-500 text-sm">Total Pengunjung</p>
                <h3 class="text-2xl font-bold" id="visitors-count">1,250</h3>
            </div>
        </div>
        <div class="mt-4 text-sm" id="visitors-change">
            <i class="fas fa-arrow-up"></i> <span id="visitors-percent">0%</span> dari bulan lalu
        </div>
    </div>
    
    <!-- Card Statistik 2 -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex items-center">
            <div class="p-3 rounded-full bg-green-100 text-green-500 mr-4">
                <i class="fas fa-shopping-cart text-xl"></i>
            </div>
            <div>
                <p class="text-gray-500 text-sm">Pesanan</p>
                <h3 class="text-2xl font-bold" id="orders-count">25</h3>
            </div>
        </div>
        <div class="mt-4 text-sm" id="orders-change">
            <i class="fas fa-arrow-up"></i> <span id="orders-percent">0%</span> dari bulan lalu
        </div>
    </div>
    
    <!-- Card Statistik 3 -->
    <div class="bg-white rounded-lg shadow-md p-6">
        <div class="flex items-center">
            <div class="p-3 rounded-full bg-purple-100 text-purple-500 mr-4">
                <i class="fas fa-money-bill-wave text-xl"></i>
            </div>
            <div>
                <p class="text-gray-500 text-sm">Pendapatan</p>
                <h3 class="text-2xl font-bold" id="revenue-count">Rp 12,500,000</h3>
            </div>
        </div>
        <div class="mt-4 text-sm" id="revenue-change">
            <i class="fas fa-arrow-up"></i> <span id="revenue-percent">0%</span> dari bulan lalu
        </div>
    </div>
</div>

<!-- Script untuk update realtime -->
<script>
// Fungsi untuk memformat angka sebagai mata uang Rupiah
function formatRupiah(angka) {
    return 'Rp ' + new Intl.NumberFormat('id-ID').format(angka);
}

function setChange(containerId, spanId, value) {
    const container = document.getElementById(containerId);
    const icon = container.querySelector('i');
    const span = document.getElementById(spanId);
    const isUp = value >= 0;
    const percentText = `${Math.abs(value).toFixed(1)}%`;
    span.textContent = percentText;
    // Reset warna
    container.classList.remove('text-green-500', 'text-red-500');
    if (isUp) {
        container.classList.add('text-green-500');
        icon.classList.remove('fa-arrow-down');
        icon.classList.add('fa-arrow-up');
    } else {
        container.classList.add('text-red-500');
        icon.classList.remove('fa-arrow-up');
        icon.classList.add('fa-arrow-down');
    }
}

// Fungsi untuk memperbarui data statistik
function updateStats() {
    fetch('/api-stats.php')
        .then(response => response.json())
        .then(data => {
            // Update statistik
            document.getElementById('visitors-count').textContent = data.visitors.toLocaleString('id-ID');
            document.getElementById('orders-count').textContent = data.orders.toLocaleString('id-ID');
            document.getElementById('revenue-count').textContent = formatRupiah(data.revenue);

            // Update persentase
            setChange('visitors-change', 'visitors-percent', data.visitorsPercent || 0);
            setChange('orders-change', 'orders-percent', data.ordersPercent || 0);
            setChange('revenue-change', 'revenue-percent', data.revenuePercent || 0);
            
            // Render tabel pesanan terbaru
            if (Array.isArray(data.recentOrders)) {
                renderRecentOrders(data.recentOrders);
            }
            
            // Update chart data
            if (window.myChart) {
                window.myChart.data.datasets[0].data = data.monthlyData;
                window.myChart.update();
            }
            
            // Perbarui timestamp
            console.log('Data diperbarui pada: ' + data.timestamp);
        })
        .catch(error => console.error('Error:', error));
}

// Perbarui data setiap 5 detik
document.addEventListener('DOMContentLoaded', function() {
    // Perbarui data pertama kali
    updateStats();
    
    // Set interval untuk pembaruan berkala
    setInterval(updateStats, 5000);
});
</script>

<!-- Tabel Pesanan Terbaru -->
<div class="bg-white rounded-lg shadow-md overflow-hidden mb-6">
    <div class="px-6 py-4 border-b border-gray-200">
        <h3 class="text-lg font-semibold text-gray-800">Pesanan Terbaru</h3>
    </div>
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Pelanggan</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Layanan</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total</th>
                </tr>
            </thead>
            <tbody id="recent-orders-tbody" class="bg-white divide-y divide-gray-200">
                <!-- Baris pesanan akan di-render dinamis -->
            </tbody>
        </table>
    </div>
</div>

<script>
function formatDate(dateStr) {
    const d = new Date(dateStr);
    return d.toLocaleDateString('id-ID', { day: '2-digit', month: 'short', year: 'numeric' });
}

function statusBadge(status) {
    const map = {
        completed: { bg: 'bg-green-100', text: 'text-green-800', label: 'Selesai' },
        process: { bg: 'bg-yellow-100', text: 'text-yellow-800', label: 'Proses' },
        pending: { bg: 'bg-blue-100', text: 'text-blue-800', label: 'Pembayaran' }
    };
    const s = map[status] || map.pending;
    return `<span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full ${s.bg} ${s.text}">${s.label}</span>`;
}

function renderRecentOrders(orders = []) {
    const tbody = document.getElementById('recent-orders-tbody');
    if (!tbody) return;
    tbody.innerHTML = '';
    orders.forEach(o => {
        const tr = document.createElement('tr');
        tr.innerHTML = `
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">#${String(o.id).padStart(6,'0')}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">${o.customer_name}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">${o.service_name}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">${formatDate(o.order_date)}</td>
            <td class="px-6 py-4 whitespace-nowrap">${statusBadge(o.status)}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">${formatRupiah(o.amount)}</td>
        `;
        tbody.appendChild(tr);
    });
}
</script>

<!-- Grafik Aktivitas -->
<div class="bg-white rounded-lg shadow-md p-6">
    <h3 class="text-lg font-semibold text-gray-800 mb-4">Aktivitas Bulanan</h3>
    <div class="h-64">
        <canvas id="monthlyActivityChart"></canvas>
    </div>
</div>

<!-- Chart.js Library -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<!-- Script untuk Line Chart dan Realtime Data -->
<script>
// Variabel global untuk chart
let myChart;

// Fungsi untuk memformat angka sebagai mata uang Rupiah
function formatRupiah(angka) {
    return 'Rp ' + new Intl.NumberFormat('id-ID').format(angka);
}

// Fungsi untuk memperbarui data statistik
function updateStats() {
    // Mengambil data dari API
    fetch('/api-stats.php')
        .then(response => response.json())
        .then(data => {
    
    // Update statistik
    document.getElementById('visitors-count').textContent = data.visitors.toLocaleString('id-ID');
    document.getElementById('orders-count').textContent = data.orders.toLocaleString('id-ID');
    document.getElementById('revenue-count').textContent = formatRupiah(data.revenue);
    
    // Update chart data
    if (myChart) {
        myChart.data.datasets[0].data = data.monthlyData;
        myChart.update();
    }
    
    // Perbarui timestamp
    console.log('Data diperbarui pada: ' + data.timestamp);
})
.catch(error => {
    console.error('Error fetching data:', error);
});
}

document.addEventListener('DOMContentLoaded', function() {
    const ctx = document.getElementById('monthlyActivityChart').getContext('2d');
    
    // Data awal untuk chart (akan diupdate oleh API)
    const initialData = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
    
    // Data untuk chart
    const data = {
        labels: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'],
        datasets: [{
            label: 'Aktivitas Bulanan',
            data: initialData,
            fill: false,
            borderColor: 'rgb(75, 192, 192)',
            tension: 0.1,
            backgroundColor: 'rgba(75, 192, 192, 0.2)',
            borderWidth: 2,
            pointBackgroundColor: 'rgb(75, 192, 192)',
            pointBorderColor: '#fff',
            pointHoverBackgroundColor: '#fff',
            pointHoverBorderColor: 'rgb(75, 192, 192)'
        }]
    };
    
    // Konfigurasi chart
    const config = {
        type: 'line',
        data: data,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)'
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            },
            plugins: {
                legend: {
                    display: true,
                    position: 'top'
                },
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.7)',
                    padding: 10,
                    titleColor: '#fff',
                    bodyColor: '#fff',
                    borderColor: 'rgba(0, 0, 0, 0.1)',
                    borderWidth: 1
                }
            }
        }
    };
    
    // Membuat chart
    myChart = new Chart(ctx, config);
    
    // Update data awal
    updateStats();
    
    // Set interval untuk pembaruan berkala (setiap 5 detik)
    setInterval(updateStats, 5000);
});
</script>