<?php

namespace App\Models;

class UserAdmin
{
    private $db;
    private $aes_key = 'createweb_secure_key_2023'; // Kunci enkripsi AES
    private $aes_method = 'AES-256-CBC'; // Metode enkripsi

    public function __construct()
    {
        // Memuat konfigurasi database
        require_once __DIR__ . '/../config.php';
        $this->db = mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    }
    
    // Fungsi untuk mengenkripsi password dengan AES
    private function encryptPassword($password)
    {
        $iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length($this->aes_method));
        $encrypted = openssl_encrypt($password, $this->aes_method, $this->aes_key, 0, $iv);
        return base64_encode($encrypted . '::' . $iv);
    }
    
    // Fungsi untuk mendekripsi password dengan AES
    private function decryptPassword($encryptedPassword)
    {
        list($encrypted_data, $iv) = explode('::', base64_decode($encryptedPassword), 2);
        return openssl_decrypt($encrypted_data, $this->aes_method, $this->aes_key, 0, $iv);
    }

    public function getAllUsers()
    {
        $query = "SELECT id, username, email FROM user_admin";
        $result = mysqli_query($this->db, $query);
        $users = [];
        
        while ($row = mysqli_fetch_assoc($result)) {
            $users[] = $row;
        }
        
        return $users;
    }

    public function getUserByUsername($username)
    {
        $username = mysqli_real_escape_string($this->db, $username);
        $query = "SELECT * FROM user_admin WHERE username = '$username' LIMIT 1";
        $result = mysqli_query($this->db, $query);
        
        return mysqli_fetch_assoc($result);
    }

    public function verifyPassword($username, $password)
    {
        $user = $this->getUserByUsername($username);
        
        if (!$user) {
            return false;
        }
        
        // Verifikasi password dengan dekripsi AES
        $decryptedPassword = $this->decryptPassword($user['password']);
        return $decryptedPassword === $password;
    }

    // Untuk migrasi database
    public function createUserAdminTable()
    {
        // Menggunakan mysqli langsung untuk membuat tabel
        $query = "CREATE TABLE IF NOT EXISTS `user_admin` (
            `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            `username` VARCHAR(50) NOT NULL,
            `email` VARCHAR(100) NOT NULL,
            `password` VARCHAR(255) NOT NULL,
            `created_at` DATETIME NULL,
            `updated_at` DATETIME NULL,
            PRIMARY KEY (`id`),
            UNIQUE KEY `username` (`username`),
            UNIQUE KEY `email` (`email`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        
        mysqli_query($this->db, $query);

        // Insert default data
        $this->insertDefaultUser();
    }

    private function insertDefaultUser()
    {
        $timestamp = date('Y-m-d H:i:s');
        
        $username = 'arydianprtma';
        $email = 'arydianprtma@gmail.com';
        $password = 'arydianprtma123';
        
        // Enkripsi password dengan AES
        $encryptedPassword = $this->encryptPassword($password);
        
        // Cek apakah data sudah ada
        $check_query = "SELECT id FROM user_admin WHERE username = '$username' LIMIT 1";
        $result = mysqli_query($this->db, $check_query);
        
        if (mysqli_num_rows($result) == 0) {
            $encryptedPassword = mysqli_real_escape_string($this->db, $encryptedPassword);
            $query = "INSERT INTO user_admin (username, email, password, created_at, updated_at) 
                      VALUES ('$username', '$email', '$encryptedPassword', '$timestamp', '$timestamp')";
            mysqli_query($this->db, $query);
        }
    }
}