<?php

namespace App\Models;

class ServicePrice
{
    private $db;

    public function __construct()
    {
        // Memuat konfigurasi database
        require_once __DIR__ . '/../config.php';
        $this->db = mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);
    }

    public function getAllPrices()
    {
        $query = "SELECT * FROM service_prices";
        $result = mysqli_query($this->db, $query);
        $prices = [];
        
        while ($row = mysqli_fetch_assoc($result)) {
            $prices[] = $row;
        }
        
        return $prices;
    }

    public function getPriceByServiceCode($serviceCode)
    {
        $serviceCode = mysqli_real_escape_string($this->db, $serviceCode);
        $query = "SELECT * FROM service_prices WHERE service_code = '$serviceCode' LIMIT 1";
        $result = mysqli_query($this->db, $query);
        
        return mysqli_fetch_assoc($result);
    }

    public function updatePrice($serviceCode, $price)
    {
        $serviceCode = mysqli_real_escape_string($this->db, $serviceCode);
        $price = (float) $price;
        $updated_at = date('Y-m-d H:i:s');
        
        $query = "UPDATE service_prices SET price = $price, updated_at = '$updated_at' 
                  WHERE service_code = '$serviceCode'";
                  
        return mysqli_query($this->db, $query);
    }

    // Untuk migrasi database
    public function createServicePricesTable()
    {
        // Menggunakan mysqli langsung untuk membuat tabel
        $query = "CREATE TABLE IF NOT EXISTS `service_prices` (
            `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
            `service_code` VARCHAR(50) NOT NULL,
            `service_name` VARCHAR(100) NOT NULL,
            `price` DECIMAL(10,2) NOT NULL,
            `created_at` DATETIME NULL,
            `updated_at` DATETIME NULL,
            PRIMARY KEY (`id`),
            UNIQUE KEY `service_code` (`service_code`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;";
        
        mysqli_query($this->db, $query);

        // Kode array field dan forge sudah tidak digunakan lagi karena menggunakan query langsung

        // Insert default data
        $this->insertDefaultPrices();
    }

    private function insertDefaultPrices()
    {
        $timestamp = date('Y-m-d H:i:s');
        
        $services = [
            ['company_profile', 'Company Profile', 3500000],
            ['ecommerce', 'E-Commerce', 7500000],
            ['landing_page', 'Landing Page', 2500000],
            ['custom_development', 'Custom Development', 10000000],
            ['optimization', 'Optimasi & Maintenance', 1500000],
            ['integration', 'Integrasi Sistem', 5000000]
        ];
        
        foreach ($services as $service) {
            $service_code = mysqli_real_escape_string($this->db, $service[0]);
            $service_name = mysqli_real_escape_string($this->db, $service[1]);
            $price = (float) $service[2];
            
            // Cek apakah data sudah ada
            $check_query = "SELECT id FROM service_prices WHERE service_code = '$service_code' LIMIT 1";
            $result = mysqli_query($this->db, $check_query);
            
            if (mysqli_num_rows($result) == 0) {
                $query = "INSERT INTO service_prices (service_code, service_name, price, created_at, updated_at) 
                          VALUES ('$service_code', '$service_name', $price, '$timestamp', '$timestamp')";
                mysqli_query($this->db, $query);
            }
        }
    }
}