<?php

namespace App\Models;

class Order {
    private $db;

    public function __construct() {
        $this->db = new \mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        if ($this->db->connect_error) {
            die("Connection failed: " . $this->db->connect_error);
        }
    }

    // Mendapatkan total pesanan
    public function getTotalOrders() {
        $query = "SELECT COUNT(*) as total FROM orders";
        $result = $this->db->query($query);
        $row = $result->fetch_assoc();
        return $row['total'] ?? 0;
    }

    // Mendapatkan total pendapatan
    public function getTotalRevenue() {
        $query = "SELECT SUM(amount) as total FROM orders";
        $result = $this->db->query($query);
        $row = $result->fetch_assoc();
        return $row['total'] ?? 0;
    }

    // Mendapatkan pesanan terbaru
    public function getRecentOrders($limit = 5) {
        $query = "SELECT * FROM orders ORDER BY order_date DESC LIMIT ?";
        $stmt = $this->db->prepare($query);
        $stmt->bind_param("i", $limit);
        $stmt->execute();
        $result = $stmt->get_result();
        
        $orders = [];
        while ($row = $result->fetch_assoc()) {
            $orders[] = $row;
        }
        
        return $orders;
    }

    // Persentase perubahan jumlah pesanan dari bulan lalu
    public function getOrdersChangePercentage() {
        $currentQuery = "SELECT COUNT(*) as total FROM orders 
                         WHERE MONTH(order_date) = MONTH(CURDATE()) 
                         AND YEAR(order_date) = YEAR(CURDATE())";
        $currentResult = $this->db->query($currentQuery);
        $currentTotal = $currentResult ? ($currentResult->fetch_assoc()['total'] ?? 0) : 0;

        $lastQuery = "SELECT COUNT(*) as total FROM orders 
                       WHERE MONTH(order_date) = MONTH(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) 
                       AND YEAR(order_date) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 MONTH))";
        $lastResult = $this->db->query($lastQuery);
        $lastTotal = $lastResult ? ($lastResult->fetch_assoc()['total'] ?? 0) : 0;

        if ($lastTotal > 0) {
            $percentage = (($currentTotal - $lastTotal) / $lastTotal) * 100;
            return round($percentage, 1);
        }
        return 0.0;
    }

    // Persentase perubahan pendapatan dari bulan lalu
    public function getRevenueChangePercentage() {
        $currentQuery = "SELECT SUM(amount) as total FROM orders 
                         WHERE MONTH(order_date) = MONTH(CURDATE()) 
                         AND YEAR(order_date) = YEAR(CURDATE())";
        $currentResult = $this->db->query($currentQuery);
        $currentTotal = $currentResult ? ($currentResult->fetch_assoc()['total'] ?? 0) : 0;

        $lastQuery = "SELECT SUM(amount) as total FROM orders 
                       WHERE MONTH(order_date) = MONTH(DATE_SUB(CURDATE(), INTERVAL 1 MONTH)) 
                       AND YEAR(order_date) = YEAR(DATE_SUB(CURDATE(), INTERVAL 1 MONTH))";
        $lastResult = $this->db->query($lastQuery);
        $lastTotal = $lastResult ? ($lastResult->fetch_assoc()['total'] ?? 0) : 0;

        if ($lastTotal > 0) {
            $percentage = (($currentTotal - $lastTotal) / $lastTotal) * 100;
            return round($percentage, 1);
        }
        return 0.0;
    }
}