<?php

namespace App\Models;

class Notification
{
    private $db;

    public function __construct()
    {
        // Memuat konfigurasi database
        require_once __DIR__ . '/../config.php';
        
        // Nonaktifkan pelaporan error mysqli untuk mencegah exception
        mysqli_report(MYSQLI_REPORT_OFF);
        
        // Koneksi ke database
        $this->db = @mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);
        
        // Jika koneksi gagal
        if (!$this->db) {
            // Tampilkan pesan error yang informatif
            echo "Koneksi database gagal: " . mysqli_connect_error();
            // Gunakan fallback untuk mencegah aplikasi berhenti total
            $this->db = null;
        }
    }

    public function getAllNotifications()
    {
        $notifications = [];
        
        // Periksa apakah koneksi database tersedia
        if ($this->db === null) {
            return $notifications;
        }
        
        $query = "SELECT * FROM notifications ORDER BY created_at DESC";
        $result = mysqli_query($this->db, $query);
        
        if ($result) {
            while ($row = mysqli_fetch_assoc($result)) {
                $notifications[] = $row;
            }
        }
        
        return $notifications;
    }

    public function getUnreadNotifications()
    {
        $notifications = [];
        
        // Periksa apakah koneksi database tersedia
        if ($this->db === null) {
            return $notifications;
        }
        
        $query = "SELECT * FROM notifications WHERE is_read = 0 ORDER BY created_at DESC";
        $result = mysqli_query($this->db, $query);
        
        if ($result) {
            while ($row = mysqli_fetch_assoc($result)) {
                $notifications[] = $row;
            }
        }
        
        return $notifications;
    }

    public function getNotificationById($id)
    {
        // Periksa apakah koneksi database tersedia
        if ($this->db === null) {
            return null;
        }
        
        $id = mysqli_real_escape_string($this->db, $id);
        $query = "SELECT * FROM notifications WHERE id = '$id' LIMIT 1";
        $result = mysqli_query($this->db, $query);
        
        return $result ? mysqli_fetch_assoc($result) : null;
    }

    public function createNotification($type, $message, $related_id = null)
    {
        // Periksa apakah koneksi database tersedia
        if ($this->db === null) {
            return false;
        }
        
        $type = mysqli_real_escape_string($this->db, $type);
        $message = mysqli_real_escape_string($this->db, $message);
        $related_id = $related_id ? mysqli_real_escape_string($this->db, $related_id) : 'NULL';
        $now = date('Y-m-d H:i:s');
        
        // Cek apakah notifikasi dengan pesan dan related_id yang sama sudah ada dalam 5 menit terakhir
        $fiveMinsAgo = date('Y-m-d H:i:s', strtotime('-5 minutes'));
        $checkQuery = "SELECT id FROM notifications 
                      WHERE message = '$message' 
                      AND related_id = $related_id 
                      AND created_at > '$fiveMinsAgo'
                      LIMIT 1";
        
        $result = mysqli_query($this->db, $checkQuery);
        
        // Jika sudah ada notifikasi serupa, jangan buat yang baru
        if ($result && mysqli_num_rows($result) > 0) {
            $row = mysqli_fetch_assoc($result);
            return $row['id']; // Kembalikan ID notifikasi yang sudah ada
        }
        
        // Jika belum ada, buat notifikasi baru
        $query = "INSERT INTO notifications (type, message, related_id, created_at) 
                  VALUES ('$type', '$message', $related_id, '$now')";
        
        if (mysqli_query($this->db, $query)) {
            return mysqli_insert_id($this->db);
        }
        
        return false;
    }

    public function markAsRead($id)
    {
        // Periksa apakah koneksi database tersedia
        if ($this->db === null) {
            return false;
        }
        
        $id = mysqli_real_escape_string($this->db, $id);
        
        $query = "UPDATE notifications SET is_read = 1 WHERE id = '$id'";
        
        return mysqli_query($this->db, $query);
    }

    public function markAllAsRead()
    {
        // Periksa apakah koneksi database tersedia
        if ($this->db === null) {
            return false;
        }
        
        $query = "UPDATE notifications SET is_read = 1 WHERE is_read = 0";
        
        return mysqli_query($this->db, $query);
    }

    public function getUnreadCount()
    {
        // Periksa apakah koneksi database tersedia
        if ($this->db === null) {
            return 0;
        }
        
        $query = "SELECT COUNT(*) as total FROM notifications WHERE is_read = 0";
        $result = mysqli_query($this->db, $query);
        
        if ($result) {
            $row = mysqli_fetch_assoc($result);
            return $row['total'];
        }
        
        return 0;
    }
}