<?php

namespace App\Controllers\Admin;

use App\Models\Visitor;
use App\Models\MonthlyActivity;
use App\Models\Order;

class StatsController
{
    public function getDashboardStats()
    {
        try {
            // Inisialisasi model
            $visitorModel = new Visitor();
            $activityModel = new MonthlyActivity();
            $orderModel = new Order();
            
            // Mendapatkan data dari database
            $totalVisitors = $visitorModel->getTotalVisitors();
            $monthlyActivityData = $activityModel->getMonthlyActivityData();
            
            // Mendapatkan data pesanan dan pendapatan dari database
            $orders = $orderModel->getTotalOrders();
            $revenue = $orderModel->getTotalRevenue();

            // Persentase perubahan MoM
            $visitorsPercent = $visitorModel->getVisitorChangePercentage();
            $ordersPercent = $orderModel->getOrdersChangePercentage();
            $revenuePercent = $orderModel->getRevenueChangePercentage();
            
            // Format data untuk respons JSON
            $data = [
                'visitors' => $totalVisitors,
                'orders' => $orders,
                'revenue' => $revenue,
                'visitorsPercent' => $visitorsPercent,
                'ordersPercent' => $ordersPercent,
                'revenuePercent' => $revenuePercent,
                'monthlyData' => $monthlyActivityData,
                'recentOrders' => $orderModel->getRecentOrders(10),
                'timestamp' => date('Y-m-d H:i:s')
            ];
            
            return json_encode($data);
        } catch (\Exception $e) {
            return json_encode([
                'error' => $e->getMessage(),
                'visitors' => 1000,
                'orders' => 30,
                'revenue' => 15000000,
                'visitorsPercent' => 0,
                'ordersPercent' => 0,
                'revenuePercent' => 0,
                'monthlyData' => [40, 60, 30, 70, 50, 65, 80, 75, 55, 60, 90, 85],
                'timestamp' => date('Y-m-d H:i:s')
            ]);
        }
    }
    
    // Menambahkan pengunjung baru
    public function recordVisit() {
        $visitorModel = new Visitor();
        return $visitorModel->addVisitor();
    }
    
    // Menambahkan aktivitas baru
    public function recordActivity($count = 1) {
        $activityModel = new MonthlyActivity();
        return $activityModel->incrementActivity($count);
    }
}