<?php

namespace App\Controllers\Admin;

use App\Core\Controller;
use App\Models\Settings;

class SettingsController extends Controller
{
    private $settingsModel;
    
    public function __construct()
    {
        // Pastikan admin sudah login
        if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
            header('Location: /admin/login');
            exit;
        }
        
        $this->settingsModel = new Settings();
    }

    public function general()
    {
        // Handle submit
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $siteName = $_POST['site_name'] ?? '';
            $email = $_POST['email'] ?? '';
            $whatsappNumber = $_POST['whatsapp_number'] ?? '';
            // Tambahkan kode negara +62 jika belum ada
            if (!empty($whatsappNumber) && !preg_match('/^\+/', $whatsappNumber)) {
                $whatsappNumber = '+62' . $whatsappNumber;
            }
            $address = $_POST['address'] ?? '';
            $workHours = $_POST['work_hours'] ?? '';
            $instagram = $_POST['instagram'] ?? '';
            $tiktok = $_POST['tiktok'] ?? '';

            // Buat array settings
            // Ganti literal \n dengan karakter newline sebenarnya
            $workHours = str_replace('\n', "\n", $workHours);
            
            $settings = [
                'site_name' => $siteName,
                'email' => $email,
                'whatsapp_number' => $whatsappNumber,
                'address' => $address,
                'work_hours' => $workHours,
                'instagram' => $instagram,
                'tiktok' => $tiktok,
            ];
            
            // Simpan ke database
            $this->settingsModel->saveSettings('general', $settings);
            
            // Simpan juga di session untuk akses cepat
            $_SESSION['settings_general'] = $settings;
            $_SESSION['success'] = 'Pengaturan umum berhasil disimpan';

            header('Location: /admin/settings/general');
            exit;
        }

        // Ambil data dari database
        $generalSettings = $this->settingsModel->getSettings('general');
        
        // Jika tidak ada di database, gunakan default
        if (!$generalSettings) {
            $generalSettings = [
                'site_name' => 'CreateWeb',
                'email' => 'info@createweb.com',
                'whatsapp_number' => '+62 812-3456-7890',
                'address' => 'Jl. Contoh No. 123, Jakarta',
                'work_hours' => 'Senin - Jumat: 09:00 - 17:00',
            ];
        }
        
        // Simpan di session untuk akses cepat
        $_SESSION['settings_general'] = $generalSettings;
        
        $data = [
            'title' => 'Pengaturan Umum',
            'general' => $generalSettings
        ];

        return $this->view('admin/settings/general', $data, 'layouts/admin');
    }
}