<?php

namespace App\Controllers\Admin;

use App\Core\Controller;
use App\Models\ServicePrice;

class ServiceController extends Controller
{
    protected $servicePriceModel;

    public function __construct()
    {
        $this->servicePriceModel = new ServicePrice();
    }

    public function index()
    {
        $data = [
            'title' => 'Kelola Harga Layanan',
            'services' => $this->servicePriceModel->getAllPrices()
        ];

        return $this->view('admin/services/index', $data, 'layouts/admin');
    }

    public function edit($serviceCode)
    {
        $service = $this->servicePriceModel->getPriceByServiceCode($serviceCode);
        if (!$service) {
            header('Location: /admin/services');
            exit;
        }
        
        $data = [
            'title' => 'Edit Harga Layanan',
            'service' => $service
        ];
        
        return $this->view('admin/services/edit', $data, 'layouts/admin');
        
        if (empty($service)) {
            header('Location: /admin/services');
            exit;
        }

        $data = [
            'title' => 'Edit Harga Layanan',
            'service' => $service
        ];

        return $this->view('admin/services/edit', $data);
    }

    public function update()
    {
        $serviceCode = $_POST['service_code'] ?? '';
        $price = $_POST['price'] ?? '';

        $this->servicePriceModel->updatePrice($serviceCode, $price);

        header('Location: /admin/services');
        exit;
    }
}