<?php

namespace App\Controllers\Admin;

use App\Models\Notification;

class NotificationController
{
    private $notification;

    public function __construct()
    {
        $this->notification = new Notification();
    }

    public function getUnread()
    {
        $notifications = $this->notification->getUnreadNotifications();
        header('Content-Type: application/json');
        echo json_encode($notifications);
    }

    public function markAsRead()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $id = $_POST['notification_id'] ?? 0;
            
            $success = $this->notification->markAsRead($id);
            
            header('Content-Type: application/json');
            echo json_encode(['success' => $success]);
        }
    }

    public function markAllAsRead()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $success = $this->notification->markAllAsRead();
            
            header('Content-Type: application/json');
            echo json_encode(['success' => $success]);
        }
    }

    public function getUnreadCount()
    {
        return $this->notification->getUnreadCount();
    }
}