<?php

namespace App\Controllers\Admin;

use App\Models\Message;
use App\Models\Notification;

class MessageController
{
    private $message;
    private $notification;

    public function __construct()
    {
        $this->message = new Message();
        $this->notification = new Notification();
    }

    public function index()
    {
        $messages = $this->message->getAllMessages();
        $unreadCount = $this->message->getUnreadMessageCount();
        
        include_once __DIR__ . '/../../Views/admin/messages/index.php';
    }

    public function view($id)
    {
        $message = $this->message->getMessageById($id);
        
        if (!$message) {
            header('Location: /admin/messages');
            exit;
        }
        
        // Tandai pesan sebagai telah dibaca
        if ($message['is_read'] == 0) {
            $this->message->markAsRead($id);
        }
        
        include_once __DIR__ . '/../../Views/admin/messages/view.php';
    }

    public function reply()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $id = $_POST['message_id'] ?? 0;
            $reply = $_POST['reply'] ?? '';
            
            if (empty($reply)) {
                $_SESSION['error'] = 'Balasan tidak boleh kosong';
                header('Location: /admin/messages/view/' . $id);
                exit;
            }
            
            $success = $this->message->replyMessage($id, $reply);
            
            if ($success) {
                $_SESSION['success'] = 'Pesan berhasil dibalas';
            } else {
                $_SESSION['error'] = 'Gagal membalas pesan';
            }
            
            header('Location: /admin/messages/view/' . $id);
            exit;
        }
        
        header('Location: /admin/messages');
        exit;
    }

    public function getUnreadCount()
    {
        return $this->message->getUnreadMessageCount();
    }
}