<?php

namespace App\Controllers\Admin;

use App\Core\Controller;

class DashboardController extends Controller
{
    public function __construct()
    {
        // Cek apakah admin sudah login
        if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
            header('Location: /admin/login');
            exit;
        }
    }

    public function index()
    {
        $data = [
            'title' => 'Dashboard Admin',
            'username' => $_SESSION['admin_username'] ?? 'Admin'
        ];

        return $this->view('admin/dashboard', $data, 'layouts/admin');
    }
}