<?php

namespace App\Controllers\Admin;

use App\Core\Controller;
use App\Models\UserAdmin;

class AuthController extends Controller
{
    protected $userAdminModel;
    
    public function __construct()
    {
        $this->userAdminModel = new UserAdmin();
    }
    
    public function login()
    {
        // Jika sudah login, redirect ke dashboard
        if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
            header('Location: /admin/dashboard');
            exit;
        }

        $data = [
            'title' => 'Admin Login'
        ];

        return $this->view('admin/login', $data, 'layouts/admin_login');
    }

    public function auth()
    {
        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';

        // Verifikasi dengan database
        if ($this->userAdminModel->verifyPassword($username, $password)) {
            // Set session
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_username'] = $username;
            
            header('Location: /admin/dashboard');
            exit;
        } else {
            $data = [
                'title' => 'Admin Login',
                'error' => 'Username atau password salah!'
            ];
            
            return $this->view('admin/login', $data, 'layouts/admin_login');
        }
    }

    public function logout()
    {
        // Hapus session admin
        unset($_SESSION['admin_logged_in']);
        unset($_SESSION['admin_username']);
        
        // Redirect ke halaman login
        header('Location: /admin/login');
        exit;
    }
}